/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Defaults;
import io.swagger.models.parameters.Parameter;
import io.vertx.core.buffer.Buffer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.RequestRootDeserializer;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootDeserializer;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.highway.HighwayOutputStream;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;

public final class HighwayCodec {
    private HighwayCodec() {
    }

    public static TcpOutputStream encodeRequest(long msgId, Invocation invocation, OperationProtobuf operationProtobuf) throws Exception {
        RequestHeader header = new RequestHeader();
        header.setMsgType(0);
        header.setFlags(0);
        header.setDestMicroservice(invocation.getMicroserviceName());
        header.setSchemaId(invocation.getSchemaId());
        header.setOperationName(invocation.getOperationName());
        header.setContext(invocation.getContext());
        HighwayOutputStream os = new HighwayOutputStream(msgId);
        os.write(header, operationProtobuf.getRequestRootSerializer(), (Object)invocation.getSwaggerArguments());
        return os;
    }

    private static Map<String, Object> addPrimitiveTypeDefaultValues(Invocation invocation, Map<String, Object> swaggerArguments) {
        if (invocation.getOperationMeta().getSwaggerProducerOperation() != null && !invocation.isEdge()) {
            List swaggerParameters = invocation.getOperationMeta().getSwaggerOperation().getParameters();
            for (Parameter parameter : swaggerParameters) {
                if (swaggerArguments.get(parameter.getName()) != null) continue;
                Type type = invocation.getOperationMeta().getSwaggerProducerOperation().getSwaggerParameterType(parameter.getName());
                swaggerArguments.put(parameter.getName(), HighwayCodec.defaultPrimitiveValue(null, type));
            }
        }
        return swaggerArguments;
    }

    public static void decodeRequest(Invocation invocation, RequestHeader header, OperationProtobuf operationProtobuf, Buffer bodyBuffer) throws Exception {
        RequestRootDeserializer requestDeserializer = operationProtobuf.getRequestRootDeserializer();
        Map swaggerArguments = requestDeserializer.deserialize(bodyBuffer.getBytes());
        HighwayCodec.addPrimitiveTypeDefaultValues(invocation, swaggerArguments);
        invocation.setSwaggerArguments(swaggerArguments);
        invocation.mergeContext(header.getContext());
    }

    public static RequestHeader readRequestHeader(Buffer headerBuffer) throws Exception {
        return RequestHeader.readObject(headerBuffer);
    }

    public static Buffer encodeResponse(long msgId, ResponseHeader header, ResponseRootSerializer bodySchema, Object body) throws Exception {
        try (HighwayOutputStream os = new HighwayOutputStream(msgId);){
            os.write(header, bodySchema, body);
            Buffer buffer = os.getBuffer();
            return buffer;
        }
    }

    public static Response decodeResponse(Invocation invocation, OperationProtobuf operationProtobuf, TcpData tcpData) throws Exception {
        ResponseHeader header = ResponseHeader.readObject(tcpData.getHeaderBuffer());
        if (header.getContext() != null) {
            invocation.getContext().putAll(header.getContext());
        }
        ResponseRootDeserializer bodySchema = operationProtobuf.findResponseRootDeserializer(header.getStatusCode());
        JavaType type = invocation.findResponseType(header.getStatusCode());
        Object body = bodySchema.deserialize(tcpData.getBodyBuffer().getBytes(), type);
        Response response = Response.create((int)header.getStatusCode(), (String)header.getReasonPhrase(), (Object)HighwayCodec.defaultPrimitiveValue(body, (Type)type));
        response.setHeaders(header.getHeaders());
        return response;
    }

    private static Object defaultPrimitiveValue(Object body, Type type) {
        if (body == null) {
            if (type instanceof Class && ((Class)type).isPrimitive()) {
                return Defaults.defaultValue((Class)((Class)type));
            }
            if (type instanceof JavaType && ((JavaType)type).isPrimitive()) {
                return Defaults.defaultValue((Class)((JavaType)type).getRawClass());
            }
        }
        return body;
    }
}

