/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public final class Exceptions {
    private static final List<ExceptionConverter<Throwable>> CONVERTERS = SPIServiceUtils.getOrLoadSortedService(ExceptionConverter.class).stream().map(converter -> converter).collect(Collectors.toList());
    private static final Map<Class<?>, ExceptionConverter<Throwable>> CACHE = new ConcurrentHashMapEx();

    private Exceptions() {
    }

    public static Throwable unwrapIncludeInvocationException(Throwable throwable) {
        return ExceptionFactory.unwrapIncludeInvocationException((Throwable)throwable);
    }

    public static <T extends Throwable> T unwrap(Throwable throwable) {
        return (T)ExceptionFactory.unwrap((Throwable)throwable);
    }

    public static InvocationException create(Response.StatusType status, Object errorData) {
        return new InvocationException(status, errorData);
    }

    public static InvocationException create(Response.StatusType status, String code, String msg) {
        return new InvocationException(status, code, msg);
    }

    private static InvocationException create(Response.StatusType status, String code, String msg, Throwable cause) {
        return new InvocationException(status, code, msg, cause);
    }

    public static InvocationException consumer(String code, String msg) {
        return Exceptions.create((Response.StatusType)Response.Status.BAD_REQUEST, code, msg);
    }

    public static InvocationException consumer(String code, String msg, Throwable cause) {
        return Exceptions.create((Response.StatusType)Response.Status.BAD_REQUEST, code, msg, cause);
    }

    public static InvocationException genericConsumer(String msg) {
        return Exceptions.consumer("SCB.00000000", msg);
    }

    public static InvocationException genericConsumer(String msg, Throwable cause) {
        return Exceptions.consumer("SCB.00000000", msg, cause);
    }

    public static InvocationException producer(String code, String msg) {
        return Exceptions.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, code, msg);
    }

    public static InvocationException producer(String code, String msg, Throwable cause) {
        return Exceptions.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, code, msg, cause);
    }

    public static InvocationException genericProducer(String msg) {
        return Exceptions.producer("SCB.50000000", msg);
    }

    public static InvocationException genericProducer(String msg, Throwable cause) {
        return Exceptions.producer("SCB.50000000", msg, cause);
    }

    public static Response.StatusType getGenericStatus(@Nonnull Invocation invocation) {
        return InvocationType.CONSUMER.equals((Object)invocation.getInvocationType()) ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR;
    }

    public static Response exceptionToResponse(@Nullable Invocation invocation, Throwable exception, Response.StatusType genericStatus) {
        InvocationException invocationException = Exceptions.convert(invocation, exception, genericStatus);
        return Response.status((Response.StatusType)invocationException.getStatus()).entity(invocationException.getErrorData());
    }

    public static InvocationException convert(@Nonnull Invocation invocation, Throwable throwable) {
        Response.StatusType genericStatus = Exceptions.getGenericStatus(invocation);
        return Exceptions.convert(invocation, throwable, genericStatus);
    }

    public static InvocationException convert(@Nullable Invocation invocation, Throwable throwable, Response.StatusType genericStatus) {
        Object unwrapped = Exceptions.unwrap(throwable);
        return CACHE.computeIfAbsent(unwrapped.getClass(), clazz -> Exceptions.findConverter(unwrapped)).convert(invocation, unwrapped, genericStatus);
    }

    private static ExceptionConverter<Throwable> findConverter(Throwable throwable) {
        for (ExceptionConverter<Throwable> converter : CONVERTERS) {
            if (!converter.canConvert(throwable)) continue;
            return converter;
        }
        throw new IllegalStateException("never happened: can not find converter for " + throwable.getClass().getName());
    }
}

