/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import com.google.common.eventbus.Subscribe;
import io.swagger.models.Swagger;
import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.SubscriberOrder;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceEvent;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceVersionEvent;
import org.apache.servicecomb.registry.api.event.DestroyMicroserviceEvent;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;

public class ServiceRegistryListener {
    private final SCBEngine scbEngine;

    public ServiceRegistryListener(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
        scbEngine.getEventBus().register((Object)this);
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroservice(CreateMicroserviceEvent event) {
        MicroserviceVersions microserviceVersions = event.getMicroserviceVersions();
        microserviceVersions.getVendorExtensions().put((Object)"scb_microservice_versions_meta", (Object)new ConsumerMicroserviceVersionsMeta(this.scbEngine, microserviceVersions));
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onDestroyMicroservice(DestroyMicroserviceEvent event) {
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroserviceVersion(CreateMicroserviceVersionEvent event) {
        boolean isServiceCenter;
        MicroserviceVersion microserviceVersion = event.getMicroserviceVersion();
        Microservice microservice = microserviceVersion.getMicroservice();
        String microserviceName = microserviceVersion.getMicroserviceName();
        MicroserviceMeta microserviceMeta = new MicroserviceMeta(this.scbEngine, microserviceName, true);
        microserviceMeta.setHandlerChain((List)this.scbEngine.getConsumerHandlerManager().getOrCreate(microserviceName));
        microserviceMeta.setFilterChain(this.scbEngine.getFilterChainsManager().createConsumerFilterChain(microserviceName));
        MicroserviceVersions microserviceVersions = microserviceVersion.getMicroserviceVersions();
        microserviceMeta.setMicroserviceVersionsMeta((MicroserviceVersionsMeta)CoreMetaUtils.getMicroserviceVersionsMeta(microserviceVersions));
        boolean bl = isServiceCenter = "default".equals(microservice.getAppId()) && "SERVICECENTER".equals(microservice.getServiceName());
        if (!isServiceCenter) {
            for (String schemaId : microservice.getSchemas()) {
                Swagger swagger = this.scbEngine.getSwaggerLoader().loadSwagger(microservice, microserviceVersion.getInstances(), schemaId);
                microserviceMeta.registerSchemaMeta(schemaId, swagger);
            }
        }
        microserviceMeta.putExtData("scb_microservice_version", microserviceVersion);
        microserviceVersion.getVendorExtensions().put((Object)"scb_microservice_meta", (Object)microserviceMeta);
    }

    public void destroy() {
        this.scbEngine.getEventBus().unregister((Object)this);
    }
}

