/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.schemadiscovery;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.invocation.endpoint.EndpointUtils;
import org.apache.servicecomb.provider.pojo.Invoker;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.schemadiscovery.SchemaDiscoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDiscovery
implements Discovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaDiscovery.class);
    public static final String NAME = "schema discovery";
    private SchemaDiscoveryService schemaDiscoveryService = null;

    public Microservice getMicroservice(String microserviceId) {
        return null;
    }

    public List<Microservice> getAllMicroservices() {
        return null;
    }

    public String getSchema(String microserviceId, Collection<MicroserviceInstance> instances, String schemaId) {
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        for (MicroserviceInstance instance : instances) {
            List endpoints;
            if (!microserviceId.equals(instance.getServiceId()) || (endpoints = instance.getEndpoints()) == null || endpoints.isEmpty()) continue;
            for (String endpoint : endpoints) {
                SchemaDiscoveryService schemaDiscoveryService = this.getOrCreateSchemaDiscoveryService();
                try {
                    String schema = schemaDiscoveryService.getSchema(EndpointUtils.parse((String)endpoint), schemaId);
                    if (StringUtils.isEmpty((CharSequence)schema)) continue;
                    return schema;
                }
                catch (Exception e) {
                    LOGGER.warn("failed query schema from endpoint {}, msg {}", (Object)endpoint, (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private SchemaDiscoveryService getOrCreateSchemaDiscoveryService() {
        if (this.schemaDiscoveryService == null) {
            String serviceName = DynamicPropertyFactory.getInstance().getStringProperty("service_description.name", "defaultMicroservice").get();
            this.schemaDiscoveryService = (SchemaDiscoveryService)Invoker.createProxy((String)serviceName, (String)"SchemaDiscoveryEndpoint", SchemaDiscoveryService.class);
        }
        return this.schemaDiscoveryService;
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        return null;
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        microserviceInstances.setMicroserviceNotExist(true);
        return microserviceInstances;
    }

    public String getRevision() {
        return null;
    }

    public void setRevision(String revision) {
    }

    public String name() {
        return NAME;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.schema.discovery.enabled", true).get();
    }

    public void init() {
    }

    public void run() {
    }

    public void destroy() {
    }

    public int getOrder() {
        return 200;
    }
}

