/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.utils.PropertyModelConverter;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.Part;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwaggerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerUtils.class);

    private SwaggerUtils() {
    }

    public static String swaggerToString(Swagger swagger) {
        try {
            return Yaml.mapper().writeValueAsString((Object)swagger);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Convert swagger to string failed, ", e);
        }
    }

    public static Swagger parseSwagger(URL url) {
        try {
            String swaggerContent = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return SwaggerUtils.internalParseSwagger(swaggerContent);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Parse swagger from url failed, url=" + url, e);
        }
    }

    public static Swagger parseAndValidateSwagger(URL url) {
        Swagger swagger = SwaggerUtils.parseSwagger(url);
        SwaggerUtils.validateSwagger(swagger);
        return swagger;
    }

    public static Swagger parseSwagger(String swaggerContent) {
        try {
            return SwaggerUtils.internalParseSwagger(swaggerContent);
        }
        catch (Throwable e) {
            throw new ServiceCombException("Parse swagger from content failed, ", e);
        }
    }

    public static Swagger parseAndValidateSwagger(String swaggerContent) {
        Swagger swagger = SwaggerUtils.parseSwagger(swaggerContent);
        SwaggerUtils.validateSwagger(swagger);
        return swagger;
    }

    public static void validateSwagger(Swagger swagger) {
        Map paths = swagger.getPaths();
        if (paths == null) {
            return;
        }
        for (Path path : paths.values()) {
            Operation operation = path.getPost();
            if (operation == null) continue;
            for (Parameter parameter : operation.getParameters()) {
                if (!BodyParameter.class.isInstance(parameter) || ((BodyParameter)parameter).getSchema() != null) continue;
                throw new ServiceCombException("swagger validator: body parameter schema is empty.");
            }
        }
    }

    private static Swagger internalParseSwagger(String swaggerContent) throws IOException {
        Swagger swagger = (Swagger)Yaml.mapper().readValue(swaggerContent, Swagger.class);
        SwaggerUtils.correctResponses(swagger);
        return swagger;
    }

    public static void correctResponses(Operation operation) {
        int okCode = Response.Status.OK.getStatusCode();
        String strOkCode = String.valueOf(okCode);
        Response okResponse = null;
        for (Map.Entry responseEntry : operation.getResponses().entrySet()) {
            Response response = (Response)responseEntry.getValue();
            if (StringUtils.isEmpty((CharSequence)response.getDescription())) {
                response.setDescription("response of " + (String)responseEntry.getKey());
            }
            if (operation.getResponses().get(strOkCode) != null) continue;
            int statusCode = NumberUtils.toInt((String)((String)responseEntry.getKey()));
            if ("default".equals(responseEntry.getKey())) {
                statusCode = okCode;
            }
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode))) continue;
            okResponse = response;
        }
        if (okResponse != null) {
            operation.addResponse(strOkCode, okResponse);
        }
    }

    public static void correctResponses(Swagger swagger) {
        if (swagger.getPaths() == null) {
            return;
        }
        for (Path path : swagger.getPaths().values()) {
            for (Operation operation : path.getOperations()) {
                SwaggerUtils.correctResponses(operation);
            }
        }
    }

    public static Map<String, Property> getBodyProperties(Swagger swagger, Parameter parameter) {
        if (!(parameter instanceof BodyParameter)) {
            return null;
        }
        Model model = ((BodyParameter)parameter).getSchema();
        if (model instanceof RefModel) {
            model = (Model)swagger.getDefinitions().get(((RefModel)model).getSimpleRef());
        }
        if (model instanceof ModelImpl) {
            return model.getProperties();
        }
        return null;
    }

    public static void addDefinitions(Swagger swagger, Type paramType) {
        Map models = ModelConverters.getInstance().readAll(paramType);
        for (Map.Entry entry : models.entrySet()) {
            Model tempModel;
            if (null != swagger.getDefinitions() && null != (tempModel = (Model)swagger.getDefinitions().get(entry.getKey())) && !tempModel.equals(entry.getValue())) {
                LOGGER.warn("duplicate param model: " + (String)entry.getKey());
                throw new IllegalArgumentException("duplicate param model: " + (String)entry.getKey());
            }
            swagger.addDefinition((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    public static void setParameterType(Swagger swagger, Type type, AbstractSerializableParameter<?> parameter) {
        SwaggerUtils.addDefinitions(swagger, type);
        Property property = ModelConverters.getInstance().readAsProperty(type);
        if (SwaggerUtils.isComplexProperty(property)) {
            String msg = String.format("not allow complex type for %s parameter, type=%s.", parameter.getIn(), type.getTypeName());
            throw new IllegalStateException(msg);
        }
        parameter.setProperty(property);
    }

    public static boolean isBean(Model model) {
        return SwaggerUtils.isBean(new PropertyModelConverter().modelToProperty(model));
    }

    public static boolean isBean(Property property) {
        return property instanceof RefProperty || property instanceof ObjectProperty;
    }

    public static boolean isComplexProperty(Property property) {
        if (property instanceof RefProperty || property instanceof ObjectProperty || property instanceof MapProperty) {
            return true;
        }
        if (ArrayProperty.class.isInstance(property)) {
            return SwaggerUtils.isComplexProperty(((ArrayProperty)property).getItems());
        }
        return false;
    }

    public static ModelImpl getModelImpl(Swagger swagger, BodyParameter bodyParameter) {
        Model model = bodyParameter.getSchema();
        if (model instanceof ModelImpl) {
            return (ModelImpl)model;
        }
        if (!(model instanceof RefModel)) {
            return null;
        }
        String simpleRef = ((RefModel)model).getSimpleRef();
        Model targetModel = (Model)swagger.getDefinitions().get(simpleRef);
        return targetModel instanceof ModelImpl ? (ModelImpl)targetModel : null;
    }

    public static void setCommaConsumes(Swagger swagger, String commaConsumes) {
        if (StringUtils.isEmpty((CharSequence)commaConsumes)) {
            return;
        }
        SwaggerUtils.setConsumes(swagger, commaConsumes.split(","));
    }

    public static void setCommaConsumes(Operation operation, String commaConsumes) {
        if (StringUtils.isEmpty((CharSequence)commaConsumes)) {
            return;
        }
        SwaggerUtils.setConsumes(operation, commaConsumes.split(","));
    }

    public static void setConsumes(Operation operation, String ... consumes) {
        List<String> consumeList = SwaggerUtils.convertConsumesOrProduces(consumes);
        if (!consumeList.isEmpty()) {
            operation.setConsumes(consumeList);
        }
    }

    public static void setConsumes(Swagger swagger, String ... consumes) {
        List<String> consumeList = SwaggerUtils.convertConsumesOrProduces(consumes);
        if (!consumeList.isEmpty()) {
            swagger.setConsumes(consumeList);
        }
    }

    public static List<String> convertConsumesOrProduces(String ... consumesOrProduces) {
        return Arrays.stream(consumesOrProduces).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    public static void setCommaProduces(Swagger swagger, String commaProduces) {
        if (StringUtils.isEmpty((CharSequence)commaProduces)) {
            return;
        }
        SwaggerUtils.setProduces(swagger, commaProduces.split(","));
    }

    public static void setCommaProduces(Operation operation, String commaProduces) {
        if (StringUtils.isEmpty((CharSequence)commaProduces)) {
            return;
        }
        SwaggerUtils.setProduces(operation, commaProduces.split(","));
    }

    public static void setProduces(Operation operation, String ... produces) {
        List<String> produceList = SwaggerUtils.convertConsumesOrProduces(produces);
        if (!produceList.isEmpty()) {
            operation.setProduces(produceList);
        }
    }

    public static void setProduces(Swagger swagger, String ... produces) {
        List<String> produceList = SwaggerUtils.convertConsumesOrProduces(produces);
        if (!produceList.isEmpty()) {
            swagger.setProduces(produceList);
        }
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls.getAnnotation(annotation) != null) {
            return true;
        }
        for (Method method : cls.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawJsonType(Parameter param) {
        Object rawJson = param.getVendorExtensions().get("x-raw-json");
        if (rawJson instanceof Boolean) {
            return (Boolean)rawJson;
        }
        return false;
    }

    public static Class<?> getInterface(Swagger swagger) {
        Info info = swagger.getInfo();
        if (info == null) {
            return null;
        }
        String name = SwaggerUtils.getInterfaceName(info.getVendorExtensions());
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return ReflectUtils.getClassByName((String)name);
    }

    public static String getClassName(Map<String, Object> vendorExtensions) {
        return (String)SwaggerUtils.getVendorExtension(vendorExtensions, "x-java-class");
    }

    public static String getInterfaceName(Map<String, Object> vendorExtensions) {
        return (String)SwaggerUtils.getVendorExtension(vendorExtensions, "x-java-interface");
    }

    public static <T> T getVendorExtension(Map<String, Object> vendorExtensions, String key) {
        if (vendorExtensions == null) {
            return null;
        }
        return (T)vendorExtensions.get(key);
    }

    public static boolean isBean(Type type) {
        if (type == null) {
            return false;
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (javaType.isContainerType() || javaType.isEnumType()) {
            return false;
        }
        Class cls = javaType.getRawClass();
        if (ClassUtils.isPrimitiveOrWrapper((Class)cls)) {
            return false;
        }
        return cls != String.class && cls != Date.class && cls != LocalDate.class && cls != byte[].class && cls != File.class && !cls.getName().equals("org.springframework.web.multipart.MultipartFile") && !Part.class.isAssignableFrom(cls);
    }

    public static boolean isFileParameter(Parameter parameter) {
        if (!(parameter instanceof FormParameter)) {
            return false;
        }
        FormParameter formParameter = (FormParameter)parameter;
        if (FileProperty.isType((String)formParameter.getType(), (String)formParameter.getFormat())) {
            return true;
        }
        Property property = formParameter.getItems();
        if (!ArrayProperty.isType((String)formParameter.getType()) || property == null) {
            return false;
        }
        return FileProperty.isType((String)property.getType(), (String)property.getFormat());
    }
}

