/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.core.invocation.ProducerInvocationFlow;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.highway.HighwayTransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayProducerInvocationFlow
extends ProducerInvocationFlow {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayProducerInvocationFlow.class);
    private final TcpConnection connection;
    private final long msgId;

    public HighwayProducerInvocationFlow(InvocationCreator invocationCreator, TcpConnection connection, long msgId) {
        super(invocationCreator);
        this.connection = connection;
        this.msgId = msgId;
    }

    protected Invocation sendCreateInvocationException(Throwable throwable) {
        LOGGER.error("Failed to prepare invocation, msgId={}", (Object)this.msgId, (Object)throwable);
        return null;
    }

    protected void sendResponse(Invocation invocation, Response response) {
        HighwayTransportContext transportContext = (HighwayTransportContext)invocation.getTransportContext();
        this.connection.write(transportContext.getResponseBuffer().getByteBuf());
    }
}

