/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.bean.BoolGetter;
import org.apache.servicecomb.foundation.common.utils.bean.BoolSetter;
import org.apache.servicecomb.foundation.common.utils.bean.ByteGetter;
import org.apache.servicecomb.foundation.common.utils.bean.ByteSetter;
import org.apache.servicecomb.foundation.common.utils.bean.CharGetter;
import org.apache.servicecomb.foundation.common.utils.bean.CharSetter;
import org.apache.servicecomb.foundation.common.utils.bean.DoubleGetter;
import org.apache.servicecomb.foundation.common.utils.bean.DoubleSetter;
import org.apache.servicecomb.foundation.common.utils.bean.FloatGetter;
import org.apache.servicecomb.foundation.common.utils.bean.FloatSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.IntGetter;
import org.apache.servicecomb.foundation.common.utils.bean.IntSetter;
import org.apache.servicecomb.foundation.common.utils.bean.LongGetter;
import org.apache.servicecomb.foundation.common.utils.bean.LongSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.common.utils.bean.ShortGetter;
import org.apache.servicecomb.foundation.common.utils.bean.ShortSetter;

public final class LambdaMetafactoryUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Map<Class<?>, Class<?>> GETTER_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> SETTER_MAP = new HashMap();

    private static void initGetterSetterMap() {
        GETTER_MAP.put(Boolean.TYPE, BoolGetter.class);
        GETTER_MAP.put(Byte.TYPE, ByteGetter.class);
        GETTER_MAP.put(Character.TYPE, CharGetter.class);
        GETTER_MAP.put(Short.TYPE, ShortGetter.class);
        GETTER_MAP.put(Integer.TYPE, IntGetter.class);
        GETTER_MAP.put(Long.TYPE, LongGetter.class);
        GETTER_MAP.put(Float.TYPE, FloatGetter.class);
        GETTER_MAP.put(Double.TYPE, DoubleGetter.class);
        SETTER_MAP.put(Boolean.TYPE, BoolSetter.class);
        SETTER_MAP.put(Byte.TYPE, ByteSetter.class);
        SETTER_MAP.put(Character.TYPE, CharSetter.class);
        SETTER_MAP.put(Short.TYPE, ShortSetter.class);
        SETTER_MAP.put(Integer.TYPE, IntSetter.class);
        SETTER_MAP.put(Long.TYPE, LongSetter.class);
        SETTER_MAP.put(Float.TYPE, FloatSetter.class);
        SETTER_MAP.put(Double.TYPE, DoubleSetter.class);
    }

    private LambdaMetafactoryUtils() {
    }

    protected static Method findAbstractMethod(Class<?> functionalInterface) {
        for (Method method : functionalInterface.getMethods()) {
            if ((method.getModifiers() & 0x400) == 0) continue;
            return method;
        }
        return null;
    }

    public static <T> T createLambda(Object instance, Method instanceMethod, Class<?> functionalIntfCls) {
        try {
            Method intfMethod = LambdaMetafactoryUtils.findAbstractMethod(functionalIntfCls);
            MethodHandle methodHandle = LOOKUP.unreflect(instanceMethod);
            MethodType intfMethodType = MethodType.methodType(intfMethod.getReturnType(), intfMethod.getParameterTypes());
            MethodType instanceMethodType = MethodType.methodType(instanceMethod.getReturnType(), instanceMethod.getParameterTypes());
            CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, intfMethod.getName(), MethodType.methodType(functionalIntfCls, instance.getClass()), intfMethodType, methodHandle, instanceMethodType);
            return (T)callSite.getTarget().bindTo(instance).invoke();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to create lambda from " + instanceMethod, e);
        }
    }

    public static <T> T createLambda(Method instanceMethod, Class<?> functionalIntfCls) {
        if (Modifier.isNative(instanceMethod.getModifiers())) {
            return null;
        }
        try {
            Method intfMethod = LambdaMetafactoryUtils.findAbstractMethod(functionalIntfCls);
            MethodHandle methodHandle = LOOKUP.unreflect(instanceMethod);
            MethodType intfMethodType = MethodType.methodType(intfMethod.getReturnType(), intfMethod.getParameterTypes());
            MethodType instanceMethodType = MethodType.methodType(intfMethod.getReturnType(), methodHandle.type().parameterList());
            CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, intfMethod.getName(), MethodType.methodType(functionalIntfCls), intfMethodType, methodHandle, instanceMethodType);
            return (T)callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to create lambda from " + instanceMethod, e);
        }
    }

    public static <T> T createGetter(Method getMethod) {
        Class<Getter> getterCls = GETTER_MAP.getOrDefault(getMethod.getReturnType(), Getter.class);
        return LambdaMetafactoryUtils.createLambda(getMethod, getterCls);
    }

    public static <C, F> Getter<C, F> createGetter(Field field) {
        LambdaMetafactoryUtils.checkAccess(field);
        return instance -> {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static void checkAccess(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            throw new IllegalStateException(String.format("Can not access field, a public field or accessor is required.Declaring class is %s, field is %s", field.getDeclaringClass().getName(), field.getName()));
        }
    }

    public static <T> T createSetter(Method setMethod) {
        Class<Setter> setterCls = SETTER_MAP.getOrDefault(setMethod.getParameterTypes()[0], Setter.class);
        return LambdaMetafactoryUtils.createLambda(setMethod, setterCls);
    }

    public static <C, F> Setter<C, F> createSetter(Field field) {
        LambdaMetafactoryUtils.checkAccess(field);
        return (instance, value) -> {
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    static {
        LambdaMetafactoryUtils.initGetterSetterMap();
    }
}

