/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class AsyncUtils {
    private AsyncUtils() {
    }

    public static <T> CompletableFuture<T> tryCatch(Supplier<CompletableFuture<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return AsyncUtils.completeExceptionally(e);
        }
    }

    public static <T> CompletableFuture<T> completeExceptionally(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <T extends Throwable> void rethrow(Throwable exception) throws T {
        throw exception;
    }

    public static <T> T toSync(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (Throwable e) {
            AsyncUtils.rethrow(e.getCause());
            return null;
        }
    }
}

