/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.client;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceFactory;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.definition.MicroserviceDefinition;
import org.apache.servicecomb.registry.version.Version;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleUtils;
import org.apache.servicecomb.registry.version.VersionUtils;
import org.apache.servicecomb.zeroconfig.ZeroConfigRegistryConstants;
import org.apache.servicecomb.zeroconfig.client.ClientUtil;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.apache.servicecomb.zeroconfig.server.ServerUtil;
import org.apache.servicecomb.zeroconfig.server.ZeroConfigRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfigClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroConfigClient.class);
    public static ZeroConfigClient INSTANCE = ZeroConfigClient.buildZeroConfigClient();
    private ZeroConfigRegistryService zeroConfigRegistryService;
    private MulticastSocket multicastSocket;
    private Microservice selfMicroservice;
    private MicroserviceInstance selfMicroserviceInstance;

    private ZeroConfigClient(ZeroConfigRegistryService zeroConfigRegistryService, MulticastSocket multicastSocket) {
        this.zeroConfigRegistryService = zeroConfigRegistryService;
        this.multicastSocket = multicastSocket;
    }

    @VisibleForTesting
    public ZeroConfigClient initZeroConfigClientWithMocked(ZeroConfigRegistryService zeroConfigRegistryService, MulticastSocket multicastSocket) {
        this.zeroConfigRegistryService = zeroConfigRegistryService;
        this.multicastSocket = multicastSocket;
        return this;
    }

    public void init() {
        MicroserviceConfigLoader loader = ConfigUtil.getMicroserviceConfigLoader();
        MicroserviceDefinition microserviceDefinition = new MicroserviceDefinition(loader.getConfigModels());
        MicroserviceFactory microserviceFactory = new MicroserviceFactory();
        this.selfMicroservice = microserviceFactory.create(microserviceDefinition);
        this.selfMicroserviceInstance = this.selfMicroservice.getInstance();
        if (StringUtils.isEmpty((String)this.selfMicroservice.getServiceId())) {
            String serviceId = ClientUtil.generateServiceId(this.selfMicroservice);
            this.selfMicroservice.setServiceId(serviceId);
            this.selfMicroserviceInstance.setServiceId(serviceId);
        }
        if (StringUtils.isEmpty((String)this.selfMicroserviceInstance.getInstanceId())) {
            String instanceId = ClientUtil.generateServiceInstanceId();
            this.selfMicroserviceInstance.setInstanceId(instanceId);
        }
    }

    private static ZeroConfigClient buildZeroConfigClient() {
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket();
            multicastSocket.setLoopbackMode(false);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create MulticastSocket object in Zero-Config mode", (Throwable)e);
        }
        return new ZeroConfigClient(new ZeroConfigRegistryService(), multicastSocket);
    }

    public boolean register() {
        String serviceInstanceId = this.doRegister(ClientUtil.convertToRegisterDataModel(this.selfMicroserviceInstance, this.selfMicroservice));
        return StringUtils.isNotEmpty((String)serviceInstanceId);
    }

    private String doRegister(ServerMicroserviceInstance instance) {
        try {
            byte[] instanceData = Json.encode((Object)instance).getBytes("UTF-8");
            DatagramPacket instanceDataPacket = new DatagramPacket(instanceData, instanceData.length, InetAddress.getByName("225.0.0.0"), ZeroConfigRegistryConstants.PORT);
            this.multicastSocket.send(instanceDataPacket);
            instance.setEvent("heartbeat");
            ClientUtil.INSTANCE.setServiceInstanceForHeartbeat(instance);
        }
        catch (IOException e) {
            LOGGER.error("Failed to Multicast Microservice Instance Registration Event in Zero-Config mode. servcieId: {} instanceId:{}", new Object[]{instance.getServiceId(), instance.getInstanceId(), e});
            return null;
        }
        return instance.getInstanceId();
    }

    public boolean unregister() {
        ServerMicroserviceInstance foundInstance = this.preUnregisterCheck();
        if (foundInstance == null) {
            LOGGER.warn("Failed to unregister as Microservice Instance doesn't exist in server side in Zero-Config mode");
            return false;
        }
        try {
            LOGGER.info("Start Multicast Microservice Instance Unregister Event in Zero-Config mode. Service ID: {}, Instance ID:{}", (Object)foundInstance.getServiceId(), (Object)foundInstance.getInstanceId());
            HashMap<String, String> unregisterEventMap = new HashMap<String, String>();
            unregisterEventMap.put("event", "unregister");
            unregisterEventMap.put("serviceId", foundInstance.getServiceId());
            unregisterEventMap.put("instanceId", foundInstance.getInstanceId());
            byte[] unregisterEventBytes = ((Object)unregisterEventMap).toString().getBytes("UTF-8");
            DatagramPacket unregisterEventDataPacket = new DatagramPacket(unregisterEventBytes, unregisterEventBytes.length, InetAddress.getByName("225.0.0.0"), ZeroConfigRegistryConstants.PORT);
            this.multicastSocket.send(unregisterEventDataPacket);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to Multicast Microservice Instance Unregister Event in Zero-Config mode. Service ID: {}, Instance ID:{}", new Object[]{foundInstance.getServiceId(), foundInstance.getInstanceId(), e});
            return false;
        }
    }

    public List<Microservice> getAllMicroservices() {
        ArrayList<Microservice> resultAllServices = new ArrayList<Microservice>();
        Map<String, Map<String, ServerMicroserviceInstance>> allServicesMap = ServerUtil.microserviceInstanceMap;
        allServicesMap.forEach((serviceId, instanceIdMap) -> instanceIdMap.forEach((instanceId, instance) -> resultAllServices.add(ClientUtil.convertToClientMicroservice(instance))));
        return resultAllServices;
    }

    public Microservice getMicroservice(String microserviceId) {
        if (this.selfMicroservice.getServiceId().equals(microserviceId)) {
            return this.selfMicroservice;
        }
        return ClientUtil.convertToClientMicroservice(this.zeroConfigRegistryService.getMicroservice(microserviceId));
    }

    public String getSchema(String microserviceId, String schemaId) {
        LOGGER.info("Retrieve schema content for Microservice ID: {}, Schema ID: {}", (Object)microserviceId, (Object)schemaId);
        if (this.selfMicroservice.getServiceId().equals(microserviceId)) {
            return this.selfMicroservice.getSchemaMap().computeIfPresent(schemaId, (k, v) -> v);
        }
        return null;
    }

    public MicroserviceInstance findMicroserviceInstance(String serviceId, String instanceId) {
        ServerMicroserviceInstance instance = this.zeroConfigRegistryService.findServiceInstance(serviceId, instanceId);
        if (instance == null) {
            LOGGER.error("Invalid serviceId OR instanceId! Failed to retrieve Microservice Instance for serviceId {} and instanceId {}", (Object)serviceId, (Object)instanceId);
            return null;
        }
        return ClientUtil.convertToClientMicroserviceInstance(instance);
    }

    public MicroserviceInstances findServiceInstances(String appId, String providerServiceName, String strVersionRule) {
        LOGGER.info("Find service instance for App ID: {}, Provider ServiceName: {}, versionRule: {} in Zero-Config mode", new Object[]{appId, providerServiceName, strVersionRule});
        MicroserviceInstances resultMicroserviceInstances = new MicroserviceInstances();
        FindInstancesResponse response = new FindInstancesResponse();
        ArrayList<MicroserviceInstance> resultInstanceList = new ArrayList<MicroserviceInstance>();
        List<ServerMicroserviceInstance> tempServerInstanceList = this.zeroConfigRegistryService.findServiceInstances(appId, providerServiceName);
        VersionRule versionRule = VersionRuleUtils.getOrCreate((String)strVersionRule);
        ServerMicroserviceInstance latestVersionInstance = this.findLatestVersionInstance(tempServerInstanceList, versionRule);
        if (latestVersionInstance != null) {
            Version latestVersion = VersionUtils.getOrCreate((String)latestVersionInstance.getVersion());
            for (ServerMicroserviceInstance serverInstance : tempServerInstanceList) {
                Version version = VersionUtils.getOrCreate((String)serverInstance.getVersion());
                if (!versionRule.isMatch(version, latestVersion)) continue;
                resultInstanceList.add(ClientUtil.convertToClientMicroserviceInstance(serverInstance));
            }
        }
        response.setInstances(resultInstanceList);
        resultMicroserviceInstances.setInstancesResponse(response);
        return resultMicroserviceInstances;
    }

    private ServerMicroserviceInstance findLatestVersionInstance(List<ServerMicroserviceInstance> instanceList, VersionRule versionRule) {
        Version latestVersion = null;
        ServerMicroserviceInstance latestVersionInstance = null;
        for (ServerMicroserviceInstance serverInstance : instanceList) {
            Version version = VersionUtils.getOrCreate((String)serverInstance.getVersion());
            if (!versionRule.isAccept(version) || latestVersion != null && version.compareTo(latestVersion) <= 0) continue;
            latestVersion = version;
            latestVersionInstance = serverInstance;
        }
        return latestVersionInstance;
    }

    private ServerMicroserviceInstance preUnregisterCheck() {
        ServerMicroserviceInstance instance = this.zeroConfigRegistryService.findServiceInstance(this.selfMicroserviceInstance.getServiceId(), this.selfMicroserviceInstance.getInstanceId());
        return instance;
    }

    public Microservice getSelfMicroservice() {
        return this.selfMicroservice;
    }

    @VisibleForTesting
    public void setSelfMicroservice(Microservice selfMicroservice) {
        this.selfMicroservice = selfMicroservice;
    }

    public MicroserviceInstance getSelfMicroserviceInstance() {
        return this.selfMicroserviceInstance;
    }

    @VisibleForTesting
    public void setSelfMicroserviceInstance(MicroserviceInstance selfMicroserviceInstance) {
        this.selfMicroserviceInstance = selfMicroserviceInstance;
    }
}

