/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.URLMappedConfigurationItem;
import org.apache.servicecomb.edge.core.URLMappedConfigurationLoader;
import org.apache.servicecomb.edge.core.Utils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.filter.ServerDiscoveryFilter;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHttpEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(CommonHttpEdgeDispatcher.class);
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.http.enabled";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.http.order";
    private static final String KEY_PATTERN = "servicecomb.http.dispatcher.edge.http.pattern";
    private static final String PATTERN_ANY = "/(.*)";
    private static final String KEY_MAPPING_PREFIX = "servicecomb.http.dispatcher.edge.http.mappings";
    private Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMapEx();
    private Map<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();
    private DiscoveryTree discoveryTree;

    public CommonHttpEdgeDispatcher() {
        if (this.enabled()) {
            this.loadConfigurations();
            this.discoveryTree = new DiscoveryTree();
            this.discoveryTree.addFilter((DiscoveryFilter)new ServerDiscoveryFilter());
        }
    }

    public int getOrder() {
        return DynamicPropertyFactory.getInstance().getIntProperty(KEY_ORDER, 40000).get();
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
    }

    public void init(Router router) {
        String pattern = DynamicPropertyFactory.getInstance().getStringProperty(KEY_PATTERN, PATTERN_ANY).get();
        router.routeWithRegex(pattern).failureHandler(this::onFailure).handler(this::onRequest);
    }

    private void loadConfigurations() {
        ConcurrentCompositeConfiguration config = (ConcurrentCompositeConfiguration)DynamicPropertyFactory.getBackingConfigurationSource();
        this.configurations = URLMappedConfigurationLoader.loadConfigurations(config, KEY_MAPPING_PREFIX);
        config.addConfigurationListener(event -> {
            if (event.getPropertyName().startsWith(KEY_MAPPING_PREFIX)) {
                LOG.info("Map rule have been changed. Reload configurations. Event=" + event.getType());
                this.configurations = URLMappedConfigurationLoader.loadConfigurations(config, KEY_MAPPING_PREFIX);
            }
        });
    }

    protected void onRequest(RoutingContext context) {
        URLMappedConfigurationItem configurationItem = this.findConfigurationItem(context.request().uri());
        if (configurationItem == null) {
            context.next();
            return;
        }
        String uri = Utils.findActualPath(context.request().uri(), configurationItem.getPrefixSegmentCount());
        Invocation invocation = new Invocation(){

            public String getConfigTransportName() {
                return "rest";
            }
        };
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation, configurationItem.getMicroserviceName(), configurationItem.getVersionRule());
        ServiceCombServer server = loadBalancer.chooseServer(invocation);
        URIEndpointObject endpointObject = new URIEndpointObject(server.getEndpoint().getEndpoint());
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(endpointObject.getHostOrIp()).setPort(endpointObject.getPort()).setSsl(Boolean.valueOf(endpointObject.isSslEnabled())).setURI(uri);
        HttpClient httpClient = endpointObject.isHttp2Enabled() ? HttpClients.getClient((String)"http2-transport-client", (boolean)false).getHttpClient() : HttpClients.getClient((String)"http-transport-client", (boolean)false).getHttpClient();
        HttpClientRequest httpClientRequest = httpClient.request(context.request().method(), requestOptions, httpClientResponse -> {
            context.response().setStatusCode(httpClientResponse.statusCode());
            httpClientResponse.headers().forEach(header -> context.response().headers().set((String)header.getKey(), (String)header.getValue()));
            httpClientResponse.handler(data -> context.response().write(data));
            httpClientResponse.endHandler(v -> context.response().end());
        });
        context.request().headers().forEach(header -> httpClientRequest.headers().set((String)header.getKey(), (String)header.getValue()));
        context.request().handler(data -> httpClientRequest.write(data));
        context.request().endHandler(v -> httpClientRequest.end());
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation, String microserviceName, String versionRule) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.discoveryTree.discovery(context, RegistrationManager.INSTANCE.getMicroservice().getAppId(), microserviceName, versionRule);
        invocation.addLocalContext("x-context-server-list", serversVersionedCache.data());
        return this.loadBalancerMap.computeIfAbsent(microserviceName, name -> this.createLoadBalancer(microserviceName));
    }

    private LoadBalancer createLoadBalancer(String microserviceName) {
        RuleExt rule = ExtensionsManager.createLoadBalancerRule((String)microserviceName);
        return new LoadBalancer(rule, microserviceName);
    }

    private URLMappedConfigurationItem findConfigurationItem(String path) {
        for (URLMappedConfigurationItem item : this.configurations.values()) {
            if (!item.getPattern().matcher(path).matches()) continue;
            return item;
        }
        return null;
    }
}

