/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.zeroconfig.ZeroConfigRegistryConstants;
import org.apache.servicecomb.zeroconfig.client.ClientUtil;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.apache.servicecomb.zeroconfig.server.ZeroConfigRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerUtil.class);
    public static MulticastSocket multicastSocket;
    private static ZeroConfigRegistryService zeroConfigRegistryService;
    private static InetAddress group;
    private static ScheduledExecutorService scheduledExecutor;
    public static Map<String, Map<String, ServerMicroserviceInstance>> microserviceInstanceMap;

    public static synchronized void init() {
        zeroConfigRegistryService = new ZeroConfigRegistryService();
        try {
            group = InetAddress.getByName("225.0.0.0");
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unknown host exception when creating MulticastSocket group" + e);
        }
        ServerUtil.startEventListenerTask();
        ServerUtil.startInstanceHealthCheckerTask();
    }

    private static void startEventListenerTask() {
        ExecutorService listenerExecutor = Executors.newSingleThreadExecutor();
        listenerExecutor.submit(() -> ServerUtil.startListenerForRegisterUnregisterEvent());
    }

    private static void startInstanceHealthCheckerTask() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List unhealthyInstanceList;
                if (!microserviceInstanceMap.isEmpty() && !(unhealthyInstanceList = ServerUtil.findUnhealthyInstances()).isEmpty()) {
                    ServerUtil.removeDeadInstance(unhealthyInstanceList);
                }
            }
        };
        scheduledExecutor.scheduleAtFixedRate(runnable, 5L, 3L, TimeUnit.SECONDS);
    }

    private static List<ServerMicroserviceInstance> findUnhealthyInstances() {
        ArrayList<ServerMicroserviceInstance> unhealthyInstanceList = new ArrayList<ServerMicroserviceInstance>();
        microserviceInstanceMap.forEach((serviceId, instanceIdMap) -> instanceIdMap.forEach((instanceId, instance) -> {
            if (instance.getLastHeartbeatTimeStamp() != null && instance.getLastHeartbeatTimeStamp().plusSeconds(3L).compareTo(Instant.now()) < 0) {
                unhealthyInstanceList.add((ServerMicroserviceInstance)instance);
                LOGGER.info("Detected a unhealthy service instance. serviceId: {}, instanceId: {}", (Object)instance.getServiceId(), (Object)instance.getInstanceId());
            }
        }));
        return unhealthyInstanceList;
    }

    private static void removeDeadInstance(List<ServerMicroserviceInstance> unhealthyInstanceList) {
        for (ServerMicroserviceInstance deadInstance : unhealthyInstanceList) {
            microserviceInstanceMap.computeIfPresent(deadInstance.getServiceId(), (serviceId, instanceIdMap) -> {
                instanceIdMap.computeIfPresent(deadInstance.getInstanceId(), (instanceId, instance) -> null);
                return !instanceIdMap.isEmpty() ? instanceIdMap : null;
            });
        }
    }

    public static ServerMicroserviceInstance convertToServerMicroserviceInstance(Map<String, String> serviceInstanceAttributeMap) {
        return ServerUtil.buildServerMicroserviceInstanceFromMap(serviceInstanceAttributeMap);
    }

    private static ServerMicroserviceInstance buildServerMicroserviceInstanceFromMap(Map<String, String> serviceAttributeMap) {
        ServerMicroserviceInstance serverMicroserviceInstance = new ServerMicroserviceInstance();
        serverMicroserviceInstance.setInstanceId(serviceAttributeMap.get("instanceId"));
        serverMicroserviceInstance.setServiceId(serviceAttributeMap.get("serviceId"));
        serverMicroserviceInstance.setStatus(serviceAttributeMap.get("status"));
        serverMicroserviceInstance.setHostName(serviceAttributeMap.get("hostName"));
        serverMicroserviceInstance.setAppId(serviceAttributeMap.get("appId"));
        serverMicroserviceInstance.setServiceName(serviceAttributeMap.get("serviceName"));
        serverMicroserviceInstance.setVersion(serviceAttributeMap.get("version"));
        serverMicroserviceInstance.setEndpoints(ServerUtil.convertStringToList(serviceAttributeMap.get("endpoints")));
        serverMicroserviceInstance.setSchemas(ServerUtil.convertStringToList(serviceAttributeMap.get("schemas")));
        return serverMicroserviceInstance;
    }

    private static List<String> convertStringToList(String listString) {
        List<String> resultList = new ArrayList<String>();
        if (listString != null && !listString.isEmpty()) {
            if (listString.contains("$")) {
                resultList = Arrays.asList(listString.split("\\$"));
            } else {
                resultList.add(listString);
            }
        }
        return resultList;
    }

    private static Map<String, String> getMapFromString(String inputStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        String str = inputStr.substring(1, inputStr.length() - 1);
        String[] keyValue = str.split(",");
        for (int i = 0; i < keyValue.length; ++i) {
            String[] str2 = keyValue[i].split("=");
            if (str2.length - 1 == 0) {
                map.put(str2[0].trim(), "");
                continue;
            }
            map.put(str2[0].trim(), str2[1].trim());
        }
        return map;
    }

    private static void initMulticastSocket() throws IOException {
        multicastSocket = new MulticastSocket(ZeroConfigRegistryConstants.PORT);
        group = InetAddress.getByName("225.0.0.0");
        multicastSocket.joinGroup(group);
    }

    private static void startListenerForRegisterUnregisterEvent() {
        try {
            try {
                byte[] buffer = new byte[ZeroConfigRegistryConstants.DATA_PACKET_BUFFER_SIZE.intValue()];
                ServerUtil.initMulticastSocket();
                while (true) {
                    DatagramPacket receivePacketBuffer = new DatagramPacket(buffer, buffer.length);
                    try {
                        multicastSocket.receive(receivePacketBuffer);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Caught error when receiving the data packet", (Object)t.getMessage());
                        if (!multicastSocket.isClosed()) continue;
                        LOGGER.info("MulticastSocket is closed. Going to restart it.");
                        ServerUtil.initMulticastSocket();
                        continue;
                    }
                    String receivedEventString = new String(receivePacketBuffer.getData(), 0, receivePacketBuffer.getLength(), "UTF-8").trim();
                    ServerUtil.handleReceivedEvent(receivedEventString);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create MulticastSocket object. Zero-Config init failed! ", e);
            }
        }
        catch (Throwable throwable) {
            if (multicastSocket != null) {
                try {
                    multicastSocket.leaveGroup(group);
                    multicastSocket.close();
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to close the MulticastSocket" + e1);
                }
            }
            throw throwable;
        }
    }

    private static void handleReceivedEvent(String receivedString) {
        if (receivedString.length() < 2 || !receivedString.startsWith("{") || !receivedString.endsWith("}")) {
            LOGGER.warn("Wrong format of the received Event string. {}", (Object)receivedString);
            return;
        }
        Map<String, String> receivedStringMap = ServerUtil.getMapFromString(receivedString);
        String event = receivedStringMap.get("event");
        if (StringUtils.isEmpty((CharSequence)event)) {
            LOGGER.warn("There is no Event property defined. {}", receivedStringMap);
            return;
        }
        switch (event) {
            case "register": {
                LOGGER.info("Received REGISTER event{}", receivedStringMap);
                zeroConfigRegistryService.registerMicroserviceInstance(receivedStringMap);
                break;
            }
            case "unregister": {
                LOGGER.info("Received UNREGISTER event{}", receivedStringMap);
                zeroConfigRegistryService.unregisterMicroserviceInstance(receivedStringMap);
                break;
            }
            case "heartbeat": {
                if (ServerUtil.isSelfServiceInstance(receivedStringMap)) break;
                zeroConfigRegistryService.heartbeat(receivedStringMap);
                break;
            }
            default: {
                LOGGER.error("Unrecognized event type. event: {}", (Object)event);
            }
        }
    }

    private static boolean isSelfServiceInstance(Map<String, String> receivedStringMap) {
        Map<String, String> serviceInstanceMapForHeartbeat = ClientUtil.getServiceInstanceMapForHeartbeat();
        if (serviceInstanceMapForHeartbeat == null) {
            return false;
        }
        String selfServiceId = serviceInstanceMapForHeartbeat.get("serviceId");
        String selfInstanceId = serviceInstanceMapForHeartbeat.get("instanceId");
        String serviceId = receivedStringMap.get("serviceId");
        String instanceId = receivedStringMap.get("instanceId");
        return selfServiceId.equals(serviceId) && selfInstanceId.equals(instanceId);
    }

    static {
        scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        microserviceInstanceMap = new ConcurrentHashMapEx();
    }
}

