/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.zeroconfig.ZeroConfigRegistryConstants;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtil.class);
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static Microservice microserviceSelf = new Microservice();
    private static Map<String, String> serviceInstanceMapForHeartbeat = null;
    private static MulticastSocket multicastSocket;

    public static Microservice getMicroserviceSelf() {
        return microserviceSelf;
    }

    public static void setMicroserviceSelf(Microservice microserviceSelf) {
        ClientUtil.microserviceSelf = microserviceSelf;
    }

    public static Map<String, String> getServiceInstanceMapForHeartbeat() {
        return serviceInstanceMapForHeartbeat;
    }

    public static void setServiceInstanceMapForHeartbeat(Map<String, String> serviceInstanceMapForHeartbeat) {
        ClientUtil.serviceInstanceMapForHeartbeat = serviceInstanceMapForHeartbeat;
    }

    public static synchronized void init() {
        try {
            multicastSocket = new MulticastSocket();
            multicastSocket.setLoopbackMode(false);
            multicastSocket.setTimeToLive(ZeroConfigRegistryConstants.TIME_TO_LIVE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create MulticastSocket object", (Throwable)e);
        }
        Runnable heartbeatRunnable = new Runnable(){

            @Override
            public void run() {
                if (serviceInstanceMapForHeartbeat != null && !serviceInstanceMapForHeartbeat.isEmpty()) {
                    try {
                        byte[] heartbeatEventDataBytes = serviceInstanceMapForHeartbeat.toString().getBytes();
                        DatagramPacket instanceDataPacket = new DatagramPacket(heartbeatEventDataBytes, heartbeatEventDataBytes.length, InetAddress.getByName("225.0.0.0"), ZeroConfigRegistryConstants.PORT);
                        multicastSocket.send(instanceDataPacket);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to send heartbeat event for object: {}", (Object)serviceInstanceMapForHeartbeat, (Object)e);
                    }
                }
            }
        };
        executor.scheduleAtFixedRate(heartbeatRunnable, 2L, 3L, TimeUnit.SECONDS);
    }

    public static Map<String, String> convertToRegisterDataModel(String serviceId, String microserviceInstanceId, MicroserviceInstance microserviceInstance, Microservice microservice) {
        HashMap<String, String> serviceInstanceTextAttributesMap = new HashMap<String, String>();
        serviceInstanceTextAttributesMap.put("event", "register");
        serviceInstanceTextAttributesMap.put("version", microservice.getVersion());
        serviceInstanceTextAttributesMap.put("serviceId", serviceId);
        serviceInstanceTextAttributesMap.put("instanceId", microserviceInstanceId);
        serviceInstanceTextAttributesMap.put("status", microserviceInstance.getStatus().toString());
        serviceInstanceTextAttributesMap.put("appId", microservice.getAppId());
        serviceInstanceTextAttributesMap.put("serviceName", microservice.getServiceName());
        String hostName = microserviceInstance.getHostName();
        serviceInstanceTextAttributesMap.put("hostName", hostName);
        serviceInstanceTextAttributesMap.put("endpoints", String.join((CharSequence)"$", microserviceInstance.getEndpoints()));
        serviceInstanceTextAttributesMap.put("schemas", String.join((CharSequence)"$", microservice.getSchemas()));
        return serviceInstanceTextAttributesMap;
    }

    public static MicroserviceInstance convertToClientMicroserviceInstance(ServerMicroserviceInstance serverMicroserviceInstance) {
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        microserviceInstance.setServiceId(serverMicroserviceInstance.getServiceId());
        microserviceInstance.setInstanceId(serverMicroserviceInstance.getInstanceId());
        microserviceInstance.setHostName(serverMicroserviceInstance.getHostName());
        microserviceInstance.setEndpoints(serverMicroserviceInstance.getEndpoints());
        microserviceInstance.setStatus(MicroserviceInstanceStatus.valueOf((String)serverMicroserviceInstance.getStatus()));
        return microserviceInstance;
    }

    public static Microservice convertToClientMicroservice(ServerMicroserviceInstance serverMicroserviceInstance) {
        Microservice microservice = new Microservice();
        microservice.setAppId(serverMicroserviceInstance.getAppId());
        microservice.setServiceId(serverMicroserviceInstance.getServiceId());
        microservice.setServiceName(serverMicroserviceInstance.getServiceName());
        microservice.setVersion(serverMicroserviceInstance.getVersion());
        microservice.setStatus(serverMicroserviceInstance.getStatus());
        microservice.setSchemas(serverMicroserviceInstance.getSchemas());
        return microservice;
    }

    public static String generateServiceId(Microservice microservice) {
        String serviceIdStringIndex = String.join((CharSequence)"/", microservice.getAppId(), microservice.getServiceName(), microservice.getVersion());
        return UUID.nameUUIDFromBytes(serviceIdStringIndex.getBytes()).toString().split("-")[0];
    }

    public static String generateServiceInstanceId() {
        return UUID.randomUUID().toString().split("-")[0];
    }
}

