/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.zeroconfig.client.ClientUtil;
import org.apache.servicecomb.zeroconfig.client.ZeroConfigClient;
import org.apache.servicecomb.zeroconfig.server.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfigRegistration
implements Registration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroConfigRegistration.class);
    public static ZeroConfigRegistration INSTANCE = new ZeroConfigRegistration();
    private static final String NAME = "zero-config registration";
    private ZeroConfigClient zeroConfigClient = ZeroConfigClient.INSTANCE;

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.zeroconfig.registry.enabled", true).get();
    }

    public void init() {
        this.zeroConfigClient.init();
        ServerUtil.init();
        ClientUtil.init();
    }

    public void run() {
        boolean registerResult = this.zeroConfigClient.register();
        if (!registerResult) {
            LOGGER.error("Failed to Register Service Instance in Zero-Config mode");
        } else {
            EventManager.getEventBus().post((Object)new MicroserviceInstanceRegisteredEvent(NAME, this.getMicroserviceInstance().getInstanceId(), false));
        }
    }

    public void destroy() {
        boolean unregisterResult = this.zeroConfigClient.unregister();
        if (!unregisterResult) {
            LOGGER.error("Failed to Unregister Service Instance in Zero-Config mode");
        }
    }

    public int getOrder() {
        return 101;
    }

    public String name() {
        return NAME;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.zeroConfigClient.getSelfMicroserviceInstance();
    }

    public Microservice getMicroservice() {
        return this.zeroConfigClient.getSelfMicroservice();
    }

    public String getAppId() {
        return this.zeroConfigClient.getSelfMicroservice().getAppId();
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        this.zeroConfigClient.getSelfMicroserviceInstance().setStatus(status);
        return true;
    }

    public void addSchema(String schemaId, String content) {
        this.zeroConfigClient.getSelfMicroservice().addSchema(schemaId, content);
    }

    public void addEndpoint(String endpoint) {
        this.zeroConfigClient.getSelfMicroserviceInstance().getEndpoints().add(endpoint);
    }

    public void addBasePath(Collection<BasePath> basePaths) {
        this.zeroConfigClient.getSelfMicroservice().getPaths().addAll(basePaths);
    }
}

