/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.validation.ConstraintViolationException;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.impl.JacksonPropertyNodeNameProvider;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterMeta(name="validator", invocationType={InvocationType.PRODUCER})
public class ParameterValidatorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidatorFilter.class);
    private static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    private final ExecutableValidator validator;

    public ParameterValidatorFilter() {
        ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).propertyNodeNameProvider((PropertyNodeNameProvider)new JacksonPropertyNodeNameProvider())).messageInterpolator((MessageInterpolator)this.messageInterpolator())).buildValidatorFactory();
        this.validator = factory.getValidator().forExecutables();
    }

    private AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(ENABLE_EL, false).get();
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        Object instance = producerOperation.getProducerInstance();
        Method method = producerOperation.getProducerMethod();
        Object[] args = invocation.toProducerArguments();
        Set violations = this.validator.validateParameters(instance, method, args, new Class[]{Default.class});
        if (violations.size() > 0) {
            LOGGER.error("Parameter validation failed : " + violations.toString());
            return AsyncUtils.completeExceptionally((Throwable)new ConstraintViolationException(violations));
        }
        return nextNode.onFilter(invocation);
    }
}

