/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.service.center.client.ServiceCenterRawClient;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.http.HttpResponse;
import org.apache.servicecomb.service.center.client.http.HttpTransport;
import org.apache.servicecomb.service.center.client.http.HttpTransportFactory;
import org.apache.servicecomb.service.center.client.http.TLSConfig;
import org.apache.servicecomb.service.center.client.http.TLSHttpsTransport;
import org.apache.servicecomb.service.center.client.model.HeartbeatsRequest;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.MicroservicesResponse;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterClient.class);
    private ServiceCenterRawClient httpClient;

    public ServiceCenterClient() {
        this(new ServiceCenterRawClient());
    }

    public ServiceCenterClient(TLSConfig tlsConfig) {
        this(tlsConfig, null);
    }

    public ServiceCenterClient(Map<String, String> extraGlobalHeaders) {
        this(null, 0, null, null, null, extraGlobalHeaders);
    }

    public ServiceCenterClient(TLSConfig tlsConfig, Map<String, String> extraGlobalHeaders) {
        this(null, 0, null, null, tlsConfig, extraGlobalHeaders);
    }

    public ServiceCenterClient(String host, int port) {
        this(host, port, null, null, null, null);
    }

    public ServiceCenterClient(String host, int port, String projectName, String tenantName, TLSConfig tlsConfig, Map<String, String> extraGlobalHeaders) {
        HttpTransport httpTransport = HttpTransportFactory.getDefaultHttpTransport();
        if (tlsConfig != null) {
            httpTransport = new TLSHttpsTransport(tlsConfig);
        }
        httpTransport.addHeaders(extraGlobalHeaders);
        this.httpClient = new ServiceCenterRawClient.Builder().setHost(host).setPort(port).setProjectName(projectName).setTenantName(tenantName).setHttpTransport(httpTransport).build();
    }

    public ServiceCenterClient(ServiceCenterRawClient serviceCenterRawClient) {
        this.httpClient = serviceCenterRawClient;
    }

    public MicroserviceInstancesResponse getServiceCenterInstances() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/health", null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                return (MicroserviceInstancesResponse)mapper.readValue(response.getContent(), MicroserviceInstancesResponse.class);
            }
            throw new OperationException("get service-center instances fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service-center instances fails", e);
        }
    }

    public String registerMicroservice(Microservice microservice) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices", null, mapper.writeValueAsString((Object)microservice));
            if (response.getStatusCode() == 200) {
                return response.getContent();
            }
            throw new OperationException("register service fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service fails", e);
        }
    }

    public MicroservicesResponse getMicroserviceList() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices", null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                return (MicroservicesResponse)mapper.readValue(response.getContent(), MicroservicesResponse.class);
            }
            throw new OperationException("get service List fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service List fails", e);
        }
    }

    public String queryServiceId(Microservice microservice) {
        try {
            URIBuilder uriBuilder = new URIBuilder("/registry/existence");
            uriBuilder.setParameter("type", "microservice");
            uriBuilder.setParameter("appId", microservice.getAppId());
            uriBuilder.setParameter("serviceName", microservice.getServiceName());
            uriBuilder.setParameter("version", microservice.getVersion());
            HttpResponse response = this.httpClient.getHttpRequest(uriBuilder.build().toString(), null, null);
            if (response.getStatusCode() == 200) {
                return response.getContent();
            }
            throw new OperationException("query serviceId fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("query serviceId fails", e);
        }
        catch (URISyntaxException e) {
            throw new OperationException("build url failed.", e);
        }
    }

    public Microservice getMicroserviceByServiceId(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId, null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                JsonNode jsonNode = mapper.readTree(response.getContent());
                return (Microservice)mapper.readValue(jsonNode.get("service").toString(), Microservice.class);
            }
            throw new OperationException("get service message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service message fails", e);
        }
    }

    public String registerMicroserviceInstance(MicroserviceInstance instance, String serviceId) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices/" + serviceId + "/instances", null, mapper.writeValueAsString((Object)instance));
            if (response.getStatusCode() == 200) {
                return response.getContent();
            }
            throw new OperationException("register service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service instance fails", e);
        }
    }

    public MicroserviceInstancesResponse getMicroserviceInstanceList(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances", null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                return (MicroserviceInstancesResponse)mapper.readValue(response.getContent(), MicroserviceInstancesResponse.class);
            }
            throw new OperationException("get service instances list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instances list fails", e);
        }
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(response.getContent());
                return (MicroserviceInstance)mapper.readValue(jsonNode.get("instance").toString(), MicroserviceInstance.class);
            }
            throw new OperationException("get service instance message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instance message fails", e);
        }
    }

    public void deleteMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.deleteHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() != 200) {
                throw new OperationException("delete service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            }
            LOGGER.info("DELETE SERVICE INSTANCE OK");
        }
        catch (IOException e) {
            throw new OperationException("delete service instance fails", e);
        }
    }

    public boolean updateMicroserviceInstanceStatus(String serviceId, String instanceId, MicroserviceInstanceStatus status) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/status?value=" + (Object)((Object)status), null, null);
            if (response.getStatusCode() == 200) {
                LOGGER.info("UPDATE STATUS OK");
                return true;
            }
            throw new OperationException("update service instance status fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service instance status fails", e);
        }
    }

    public void sendHeartBeats(HeartbeatsRequest heartbeatsRequest) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HttpResponse response = this.httpClient.putHttpRequest("/registry/heartbeats", null, mapper.writeValueAsString((Object)heartbeatsRequest));
            if (response.getStatusCode() != 200) {
                throw new OperationException("heartbeats fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            }
            LOGGER.info("HEARTBEATS SUCCESS");
        }
        catch (IOException e) {
            throw new OperationException("heartbeats fails ", e);
        }
    }

    public List<SchemaInfo> getServiceSchemasList(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/schemas", null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(response.getContent());
                return (List)mapper.readValue(jsonNode.get("schemas").toString(), (TypeReference)new TypeReference<List<SchemaInfo>>(){});
            }
            throw new OperationException("get service schemas list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas list fails", e);
        }
    }

    public String getServiceSchemaContext(String serviceId, String schemaId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(response.getContent());
                return jsonNode.get("schema").textValue();
            }
            throw new OperationException("get service schema context fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas context fails", e);
        }
    }

    public boolean updateServiceSchemaContext(String serviceId, String schemaId, SchemaInfo schemaInfo) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, mapper.writeValueAsString((Object)schemaInfo));
            if (response.getStatusCode() == 200) {
                LOGGER.info("UPDATE SCHEMA OK");
                return true;
            }
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }
}

