/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;
import org.apache.servicecomb.serviceregistry.registry.cache.RefreshableMicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.ServiceRegistryCache;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableServiceRegistryCache
implements ServiceRegistryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshableServiceRegistryCache.class);
    Map<MicroserviceCacheKey, RefreshableMicroserviceCache> microserviceCache = new ConcurrentHashMapEx();
    Microservice consumerService;
    ServiceRegistryClient srClient;
    boolean emptyInstanceProtectionEnabled = false;
    Consumer<List<MicroserviceCache>> cacheRefreshedWatcher;
    ReentrantLock refreshLock = new ReentrantLock();

    public RefreshableServiceRegistryCache(Microservice consumerService, ServiceRegistryClient srClient) {
        this.consumerService = consumerService;
        this.srClient = srClient;
    }

    public void refreshCache() {
        if (!this.refreshLock.tryLock()) {
            LOGGER.info("ignore concurrent refresh request");
            return;
        }
        try {
            List<MicroserviceCache> refreshedCaches = this.refreshInnerState(false);
            this.notifyWatcher(refreshedCaches);
        }
        catch (Exception e) {
            LOGGER.error("failed to refresh caches", (Throwable)e);
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    public void forceRefreshCache() {
        this.refreshLock.lock();
        try {
            List<MicroserviceCache> refreshedCaches = this.refreshInnerState(true);
            this.notifyWatcher(refreshedCaches);
        }
        catch (Exception e) {
            LOGGER.error("failed to refresh caches", (Throwable)e);
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    private List<MicroserviceCache> refreshInnerState(boolean isForced) {
        return this.microserviceCache.values().stream().peek(cache -> {
            if (isForced) {
                cache.forceRefresh();
            } else {
                cache.refresh();
            }
        }).filter(this::isRefreshedMicroserviceCache).peek(this::removeCacheIfServiceNotFound).collect(Collectors.toList());
    }

    private boolean isRefreshedMicroserviceCache(MicroserviceCache microserviceCache) {
        return MicroserviceCache.MicroserviceCacheStatus.REFRESHED.equals((Object)microserviceCache.getStatus()) || MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND.equals((Object)microserviceCache.getStatus());
    }

    private void notifyWatcher(List<MicroserviceCache> refreshedCaches) {
        if (refreshedCaches.isEmpty() || null == this.cacheRefreshedWatcher) {
            return;
        }
        this.cacheRefreshedWatcher.accept(refreshedCaches);
    }

    @Override
    public MicroserviceCache findServiceCache(MicroserviceCacheKey microserviceCacheKey) {
        microserviceCacheKey.validate();
        RefreshableMicroserviceCache targetCache = this.microserviceCache.computeIfAbsent(microserviceCacheKey, pk -> {
            RefreshableMicroserviceCache microserviceCache = this.createMicroserviceCache(microserviceCacheKey);
            microserviceCache.refresh();
            return microserviceCache;
        });
        this.removeCacheIfServiceNotFound(targetCache);
        return targetCache;
    }

    private void removeCacheIfServiceNotFound(MicroserviceCache targetCache) {
        if (MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND.equals((Object)targetCache.getStatus())) {
            this.microserviceCache.remove(targetCache.getKey());
            LOGGER.info("microserviceCache[{}] got removed", (Object)targetCache.getKey());
        }
    }

    RefreshableMicroserviceCache createMicroserviceCache(MicroserviceCacheKey microserviceCacheKey) {
        return new RefreshableMicroserviceCache(this.consumerService, microserviceCacheKey, this.srClient, this.emptyInstanceProtectionEnabled);
    }

    public RefreshableServiceRegistryCache setEmptyInstanceProtectionEnabled(boolean emptyInstanceProtectionEnabled) {
        this.emptyInstanceProtectionEnabled = emptyInstanceProtectionEnabled;
        return this;
    }

    @Override
    public ServiceRegistryCache setCacheRefreshedWatcher(Consumer<List<MicroserviceCache>> cacheRefreshedWatcher) {
        this.cacheRefreshedWatcher = cacheRefreshedWatcher;
        return this;
    }

    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent event) {
        List<MicroserviceCache> refreshedCaches = this.microserviceCache.entrySet().stream().peek(cacheEntry -> ((RefreshableMicroserviceCache)cacheEntry.getValue()).onMicroserviceInstanceChanged(event)).filter(cacheEntry -> this.isRefreshedMicroserviceCache((MicroserviceCache)cacheEntry.getValue())).map(Map.Entry::getValue).collect(Collectors.toList());
        this.notifyWatcher(refreshedCaches);
    }

    public void onSafeModeChanged(SafeModeChangeEvent modeChangeEvent) {
        for (Map.Entry<MicroserviceCacheKey, RefreshableMicroserviceCache> cacheEntry : this.microserviceCache.entrySet()) {
            cacheEntry.getValue().onSafeModeChanged(modeChangeEvent);
        }
    }

    @Override
    public Map<MicroserviceCacheKey, MicroserviceCache> getMicroserviceCaches() {
        return Collections.unmodifiableMap(this.microserviceCache);
    }
}

