/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;

public class AggregateMicroserviceCache
implements MicroserviceCache {
    private MicroserviceCacheKey key;
    Map<String, MicroserviceCache> caches;
    AtomicLong revisionCounter = new AtomicLong();
    private String revisionId = this.revisionCounter.toString();
    private MicroserviceCache.MicroserviceCacheStatus status = MicroserviceCache.MicroserviceCacheStatus.INIT;
    private List<MicroserviceInstance> instances = new ArrayList<MicroserviceInstance>();
    Collection<ServiceRegistry> serviceRegistries;
    private final Object refreshLock = new Object();

    public AggregateMicroserviceCache(MicroserviceCacheKey key, Collection<ServiceRegistry> serviceRegistries) {
        this.key = key;
        this.serviceRegistries = serviceRegistries;
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshInnerState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInnerState(boolean b) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.fillInMicroserviceCaches(b);
            this.fillInInstanceList();
            this.updateRevisionId();
            this.refreshStatus();
        }
    }

    @Override
    public void forceRefresh() {
        this.refreshInnerState(true);
    }

    private void fillInMicroserviceCaches(boolean isForce) {
        LinkedHashMap<String, MicroserviceCache> cacheMap = new LinkedHashMap<String, MicroserviceCache>();
        for (ServiceRegistry serviceRegistry : this.serviceRegistries) {
            MicroserviceCache microserviceCache = serviceRegistry.findMicroserviceCache(this.key);
            if (!this.isValidMicroserviceCache(microserviceCache)) continue;
            if (isForce) {
                microserviceCache.forceRefresh();
            }
            cacheMap.put(serviceRegistry.getName(), microserviceCache);
        }
        this.caches = cacheMap;
    }

    private void fillInInstanceList() {
        ArrayList<MicroserviceInstance> instances = new ArrayList<MicroserviceInstance>();
        for (Map.Entry<String, MicroserviceCache> stringMicroserviceCacheEntry : this.caches.entrySet()) {
            instances.addAll(stringMicroserviceCacheEntry.getValue().getInstances());
        }
        this.instances = Collections.unmodifiableList(instances);
    }

    private void updateRevisionId() {
        this.revisionCounter.incrementAndGet();
        this.revisionId = this.revisionCounter.toString();
    }

    private void refreshStatus() {
        this.status = this.caches.size() == 0 ? MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND : MicroserviceCache.MicroserviceCacheStatus.REFRESHED;
    }

    private boolean isValidMicroserviceCache(MicroserviceCache microserviceCache) {
        return !Objects.isNull(microserviceCache) && !MicroserviceCache.MicroserviceCacheStatus.SERVICE_NOT_FOUND.equals((Object)microserviceCache.getStatus());
    }

    @Override
    public MicroserviceCacheKey getKey() {
        return this.key;
    }

    @Override
    public List<MicroserviceInstance> getInstances() {
        return this.instances;
    }

    @Override
    public String getRevisionId() {
        return this.revisionId;
    }

    @Override
    public MicroserviceCache.MicroserviceCacheStatus getStatus() {
        return this.status;
    }
}

