/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.HashMap;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.rest.client.RestTransportClient;
import org.apache.servicecomb.transport.rest.client.RestTransportClientManager;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServletRestTransport
extends AbstractTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRestTransport.class);
    private RestTransportClient restClient;

    public String getName() {
        return "rest";
    }

    public boolean canInit() {
        String listenAddress = ServletConfig.getLocalServerAddress();
        if (listenAddress == null) {
            return true;
        }
        if (!ServletUtils.canPublishEndpoint(listenAddress)) {
            LOGGER.info("ignore transport {}.", (Object)((Object)((Object)this)).getClass().getName());
            return false;
        }
        return true;
    }

    public boolean init() {
        String urlPrefix = Deployment.getClassLoaderScopeProperty((String)"urlPrefix");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)urlPrefix)) {
            queryMap.put("urlPrefix", urlPrefix);
        }
        String listenAddress = ServletConfig.getLocalServerAddress();
        this.setListenAddressWithoutSchema(listenAddress, queryMap);
        this.restClient = RestTransportClientManager.INSTANCE.getRestClient();
        return true;
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.restClient.send(invocation, asyncResp);
    }
}

