/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.deployment;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.deployment.DeploymentProvider;
import org.apache.servicecomb.deployment.SystemBootstrapInfo;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;

public class Deployment {
    private static final Map<String, String> CLASS_LOADER_SCOPE_CONTEXT = new HashMap<String, String>();
    private static List<DeploymentProvider> providerList = SPIServiceUtils.getSortedService(DeploymentProvider.class);

    public static SystemBootstrapInfo getSystemBootStrapInfo(String systemKey) {
        for (DeploymentProvider provider : providerList) {
            if (provider.getSystemBootStrapInfo(systemKey) == null) continue;
            return provider.getSystemBootStrapInfo(systemKey);
        }
        return null;
    }

    public static void setClassLoaderScopeProperty(String key, String value) {
        CLASS_LOADER_SCOPE_CONTEXT.put(key, value);
    }

    public static String getClassLoaderScopeProperty(String key) {
        return CLASS_LOADER_SCOPE_CONTEXT.get(key);
    }

    @VisibleForTesting
    public static void clearClassLoaderScopeProperty() {
        CLASS_LOADER_SCOPE_CONTEXT.clear();
    }
}

