/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.netflix.config.ConcurrentCompositeConfiguration;
import io.vertx.core.http.HttpVersion;
import org.apache.servicecomb.config.client.ConfigCenterConfig;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;

public class ConfigCenterHttpClientOptionsSPI
implements HttpClientOptionsSPI {
    public static final String CLIENT_NAME = "config-center";

    public String clientName() {
        return CLIENT_NAME;
    }

    public int getOrder() {
        return -100;
    }

    public boolean enabled() {
        return Deployment.getSystemBootStrapInfo((String)"ConfigCenter") != null;
    }

    public String getConfigTag() {
        return "cc.consumer";
    }

    public ConcurrentCompositeConfiguration getConfigReader() {
        return ConfigCenterConfig.getConcurrentCompositeConfiguration();
    }

    public int getEventLoopPoolSize() {
        return ConfigCenterConfig.INSTANCE.getEventLoopSize();
    }

    public boolean useSharedVertx() {
        return false;
    }

    public int getInstanceCount() {
        return ConfigCenterConfig.INSTANCE.getVerticalInstanceCount();
    }

    public boolean isWorker() {
        return false;
    }

    public String getWorkerPoolName() {
        return null;
    }

    public int getWorkerPoolSize() {
        return 20;
    }

    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    public int getConnectTimeoutInMillis() {
        return ConfigCenterConfig.INSTANCE.getConnectionTimeout();
    }

    public int getIdleTimeoutInSeconds() {
        return ConfigCenterConfig.INSTANCE.getIdleTimeoutInSeconds();
    }

    public boolean isTryUseCompression() {
        return false;
    }

    public int getMaxWaitQueueSize() {
        return -1;
    }

    public int getMaxPoolSize() {
        return 5;
    }

    public boolean isKeepAlive() {
        return true;
    }

    public int getMaxHeaderSize() {
        return 8192;
    }

    public int getKeepAliveTimeout() {
        return 60;
    }

    public int getHttp2MultiplexingLimit() {
        return -1;
    }

    public int getHttp2MaxPoolSize() {
        return 1;
    }

    public boolean isUseAlpn() {
        return false;
    }

    public boolean isProxyEnable() {
        return ConfigCenterConfig.INSTANCE.isProxyEnable();
    }

    public String getProxyHost() {
        return ConfigCenterConfig.INSTANCE.getProxyHost();
    }

    public int getProxyPort() {
        return ConfigCenterConfig.INSTANCE.getProxyPort();
    }

    public String getProxyUsername() {
        return ConfigCenterConfig.INSTANCE.getProxyUsername();
    }

    public String getProxyPassword() {
        return ConfigCenterConfig.INSTANCE.getProxyPasswd();
    }

    public boolean isSsl() {
        return ConfigCenterConfig.INSTANCE.getServerUri().get(0).startsWith("https");
    }
}

