/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.consumer.StaticMicroserviceVersions;

public class MicroserviceReferenceConfig {
    private final ConsumerMicroserviceVersionsMeta microserviceVersionsMeta;
    private final MicroserviceVersionRule microserviceVersionRule;
    private final MicroserviceVersion latestMicroserviceVersion;
    private final MicroserviceMeta latestMicroserviceMeta;
    private final String versionRule;
    private final Supplier<Boolean> versionRuleChangedChecker;

    public MicroserviceReferenceConfig(ConsumerMicroserviceVersionsMeta microserviceVersionsMeta, String versionRule) {
        this.microserviceVersionsMeta = microserviceVersionsMeta;
        this.versionRule = versionRule != null ? versionRule : microserviceVersionsMeta.getMicroserviceConfig().getVersionRule();
        this.versionRuleChangedChecker = this.versionRule != null ? this::checkByConfig : this::notChange;
        this.microserviceVersionRule = microserviceVersionsMeta.getMicroserviceVersions().getOrCreateMicroserviceVersionRule(this.versionRule);
        this.latestMicroserviceVersion = this.microserviceVersionRule.getLatestMicroserviceVersion();
        this.latestMicroserviceMeta = this.latestMicroserviceVersion != null ? CoreMetaUtils.getMicroserviceMeta(this.latestMicroserviceVersion) : null;
    }

    private Boolean notChange() {
        return false;
    }

    private Boolean checkByConfig() {
        return !Objects.equals(this.versionRule, this.microserviceVersionsMeta.getMicroserviceConfig().getVersionRule());
    }

    public MicroserviceMeta getLatestMicroserviceMeta() {
        if (this.latestMicroserviceVersion == null) {
            throw new IllegalStateException(String.format("Probably invoke a service before it is registered, or no instance found for it, appId=%s, name=%s, versionRule=%s.", this.microserviceVersionRule.getAppId(), this.microserviceVersionRule.getMicroserviceName(), this.versionRule));
        }
        return this.latestMicroserviceMeta;
    }

    public ReferenceConfig createReferenceConfig(OperationMeta operationMeta) {
        return this.createReferenceConfig(null, operationMeta);
    }

    public ReferenceConfig createReferenceConfig(String transport, OperationMeta operationMeta) {
        if (transport == null) {
            transport = operationMeta.getConfig().getTransport();
        }
        ReferenceConfig referenceConfig = new ReferenceConfig(transport, this.versionRule);
        this.mark3rdPartyService(operationMeta, referenceConfig);
        return referenceConfig;
    }

    private void mark3rdPartyService(OperationMeta operationMeta, ReferenceConfig referenceConfig) {
        MicroserviceVersions microserviceVersions = RegistryUtils.getAppManager().getOrCreateMicroserviceVersions(operationMeta.getMicroserviceMeta().getAppId(), operationMeta.getMicroserviceName());
        referenceConfig.setThirdPartyService(microserviceVersions instanceof StaticMicroserviceVersions);
    }

    public boolean isExpired() {
        return this.microserviceVersionsMeta.getMicroserviceVersions().isWaitingDelete() || this.latestMicroserviceVersion != this.microserviceVersionRule.getLatestMicroserviceVersion() || this.versionRuleChangedChecker.get() != false;
    }
}

