/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.handler.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.swagger.invocation.extension.ProducerInvokeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerOperationHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerOperationHandler.class);
    public static final ProducerOperationHandler INSTANCE = new ProducerOperationHandler();

    @Override
    public void handle(Invocation invocation, AsyncResponse asyncResp) {
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        if (producerOperation == null) {
            asyncResp.producerFail((Throwable)ExceptionUtils.producerOperationNotExist(invocation.getSchemaId(), invocation.getOperationName()));
            return;
        }
        this.invoke(invocation, producerOperation, asyncResp);
    }

    private void invoke(Invocation invocation, SwaggerProducerOperation producerOperation, AsyncResponse asyncResp) {
        if (CompletableFuture.class.equals(producerOperation.getProducerMethod().getReturnType())) {
            this.completableFutureInvoke(invocation, producerOperation, asyncResp);
            return;
        }
        this.syncInvoke(invocation, producerOperation, asyncResp);
    }

    public void completableFutureInvoke(Invocation invocation, SwaggerProducerOperation producerOperation, AsyncResponse asyncResp) {
        ContextUtils.setInvocationContext((InvocationContext)invocation);
        this.doCompletableFutureInvoke(invocation, producerOperation, asyncResp);
        ContextUtils.removeInvocationContext();
    }

    public void doCompletableFutureInvoke(Invocation invocation, SwaggerProducerOperation producerOperation, AsyncResponse asyncResp) {
        try {
            invocation.onBusinessMethodStart();
            Object[] args = invocation.toProducerArguments();
            for (ProducerInvokeExtension producerInvokeExtension : producerOperation.getProducerInvokeExtenstionList()) {
                producerInvokeExtension.beforeMethodInvoke((SwaggerInvocation)invocation, producerOperation, args);
            }
            Object result = producerOperation.getProducerMethod().invoke(producerOperation.getProducerInstance(), args);
            invocation.onBusinessMethodFinish();
            ((CompletableFuture)result).whenComplete((realResult, ex) -> {
                invocation.onBusinessFinish();
                if (ex == null) {
                    asyncResp.handle(producerOperation.getResponseMapper().mapResponse(invocation.getStatus(), realResult));
                    return;
                }
                asyncResp.handle(this.processException(invocation, (Throwable)ex));
            });
        }
        catch (Throwable e) {
            if (this.shouldPrintErrorLog(e)) {
                invocation.getTraceIdLogger().error(LOGGER, "unexpected error {},", invocation.getInvocationQualifiedName(), e);
            }
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            asyncResp.handle(this.processException(invocation, e));
        }
    }

    public void syncInvoke(Invocation invocation, SwaggerProducerOperation producerOperation, AsyncResponse asyncResp) {
        ContextUtils.setInvocationContext((InvocationContext)invocation);
        Response response = this.doInvoke(invocation, producerOperation);
        ContextUtils.removeInvocationContext();
        asyncResp.handle(response);
    }

    public Response doInvoke(Invocation invocation, SwaggerProducerOperation producerOperation) {
        Response response;
        try {
            invocation.onBusinessMethodStart();
            Object[] args = invocation.toProducerArguments();
            for (ProducerInvokeExtension producerInvokeExtension : producerOperation.getProducerInvokeExtenstionList()) {
                producerInvokeExtension.beforeMethodInvoke((SwaggerInvocation)invocation, producerOperation, args);
            }
            Object result = producerOperation.getProducerMethod().invoke(producerOperation.getProducerInstance(), args);
            response = producerOperation.getResponseMapper().mapResponse(invocation.getStatus(), result);
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
        }
        catch (Throwable e) {
            if (this.shouldPrintErrorLog(e)) {
                invocation.getTraceIdLogger().error(LOGGER, "unexpected error {},", invocation.getInvocationQualifiedName(), e);
            }
            invocation.onBusinessMethodFinish();
            invocation.onBusinessFinish();
            response = this.processException(invocation, e);
        }
        return response;
    }

    protected boolean shouldPrintErrorLog(Throwable throwable) {
        if (!(throwable instanceof InvocationTargetException)) {
            return true;
        }
        Throwable targetException = ((InvocationTargetException)throwable).getTargetException();
        return !(targetException instanceof InvocationException);
    }

    protected Response processException(SwaggerInvocation invocation, Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        return ExceptionFactory.convertExceptionToResponse((SwaggerInvocation)invocation, (Throwable)e);
    }
}

