/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;

public class Endpoint {
    private final String endpoint;
    private final Transport transport;
    private final MicroserviceInstance instance;
    private final Object address;

    public Endpoint(Transport transport, String endpoint) {
        this(transport, endpoint, null);
    }

    public Endpoint(Transport transport, String endpoint, MicroserviceInstance instance) {
        this.transport = transport;
        this.endpoint = endpoint;
        this.instance = instance;
        this.address = transport.parseAddress(this.endpoint);
    }

    public Endpoint(Transport transport, String endpoint, MicroserviceInstance instance, Object address) {
        this.transport = transport;
        this.endpoint = endpoint;
        this.instance = instance;
        this.address = address;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.instance;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Object getAddress() {
        return this.address;
    }

    public String toString() {
        return this.endpoint;
    }
}

