/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.ParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class JsonViewProcessor
implements ParameterProcessor<Parameter, Annotation> {
    @Override
    public Type getProcessType() {
        return JsonView.class;
    }

    @Override
    public String getParameterName(Annotation parameterAnnotation) {
        return null;
    }

    @Override
    public HttpParameterType getHttpParameterType(Annotation parameterAnnotation) {
        return null;
    }

    @Override
    public void fillParameter(Swagger swagger, Operation operation, Parameter parameter, Type type, Annotation annotation) {
        if (!(annotation instanceof JsonView)) {
            throw new IllegalArgumentException("JsonViewProcessor only support process parameter with annotation @JsonView");
        }
        Class[] jvValue = ((JsonView)annotation).value();
        if (jvValue.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for exactly 1 class argument ");
        }
        parameter.getVendorExtensions().put("x-json-view", jvValue[0].getName());
    }
}

