/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.model;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import java.util.HashMap;
import java.util.Map;

public class SwaggerOperation {
    private Swagger swagger;
    private String path;
    private HttpMethod httpMethod;
    private Operation operation;
    private Map<String, Integer> parameterIndexes = new HashMap<String, Integer>();

    public SwaggerOperation(Swagger swagger, String path, HttpMethod httpMethod, Operation operation) {
        this.swagger = swagger;
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
        for (int idx = 0; idx < operation.getParameters().size(); ++idx) {
            this.parameterIndexes.put(((Parameter)operation.getParameters().get(idx)).getName(), idx);
        }
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getOperationId() {
        return this.operation.getOperationId();
    }

    public Integer findPrameterIndex(String name) {
        return this.parameterIndexes.get(name);
    }
}

