/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.InspectorImpl;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectorBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorBootListener.class);
    private InspectorConfig inspectorConfig;

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    public void onAfterTransport(BootListener.BootEvent event) {
        this.inspectorConfig = (InspectorConfig)event.getScbEngine().getPriorityPropertyManager().createConfigObject(InspectorConfig.class, new Object[0]);
        if (!this.inspectorConfig.isEnabled()) {
            LOGGER.info("inspector is not enabled.");
            return;
        }
        LOGGER.info("inspector is enabled.");
        InspectorImpl inspector = new InspectorImpl(event.getScbEngine(), this.inspectorConfig, RegistryUtils.getServiceRegistry().getMicroservice().getSchemaMap());
        inspector.setPriorityPropertyManager(event.getScbEngine().getPriorityPropertyManager());
        event.getScbEngine().getProducerProviderManager().registerSchema("inspector", (Object)inspector);
    }

    public void onAfterClose(BootListener.BootEvent event) {
        if (this.inspectorConfig != null) {
            event.getScbEngine().getPriorityPropertyManager().unregisterConfigObject((Object)this.inspectorConfig);
        }
    }
}

