/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ProtobufManager;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.foundation.common.Holder;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayServerInvoke {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayServerInvoke.class);
    private RequestHeader header;
    private OperationMeta operationMeta;
    private TcpConnection connection;
    private long msgId;
    private Buffer bodyBuffer;
    private Endpoint endpoint;
    private Invocation invocation;
    private OperationProtobuf operationProtobuf;
    private long start = System.nanoTime();

    public HighwayServerInvoke(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean init(TcpConnection connection, long msgId, RequestHeader header, Buffer bodyBuffer) {
        try {
            this.doInit(connection, msgId, header, bodyBuffer);
            return true;
        }
        catch (Throwable e) {
            String microserviceQualifiedName = "unknown";
            if (this.operationMeta != null) {
                microserviceQualifiedName = this.operationMeta.getMicroserviceQualifiedName();
            }
            String msg = String.format("decode request error, microserviceQualifiedName=%s, msgId=%d", microserviceQualifiedName, msgId);
            LOGGER.error(msg, e);
            return false;
        }
    }

    private void doInit(TcpConnection connection, long msgId, RequestHeader header, Buffer bodyBuffer) throws Exception {
        this.connection = connection;
        this.msgId = msgId;
        this.header = header;
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(header.getSchemaId());
        this.operationMeta = schemaMeta.ensureFindOperation(header.getOperationName());
        this.bodyBuffer = bodyBuffer;
    }

    private void runInExecutor() {
        try {
            if (this.isInQueueTimeout()) {
                throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Timeout when processing the request.");
            }
            this.doRunInExecutor();
        }
        catch (Throwable e) {
            String msg = String.format("handle request error, %s, msgId=%d", this.operationMeta.getMicroserviceQualifiedName(), this.msgId);
            LOGGER.error(msg, e);
            this.sendResponse(this.header.getContext(), Response.providerFailResp((Throwable)e));
        }
    }

    private boolean isInQueueTimeout() {
        return System.nanoTime() - this.invocation.getInvocationStageTrace().getStart() > this.operationMeta.getConfig().getNanoHighwayRequestWaitInPoolTimeout();
    }

    private void doRunInExecutor() throws Exception {
        this.invocation.onExecuteStart();
        this.invocation.getInvocationStageTrace().startServerFiltersRequest();
        HighwayCodec.decodeRequest(this.invocation, this.header, this.operationProtobuf, this.bodyBuffer);
        this.invocation.getHandlerContext().put("x-cse-remote-address", this.connection.getNetSocket().remoteAddress());
        this.invocation.getInvocationStageTrace().startHandlersRequest();
        this.invocation.next(response -> this.sendResponse(this.invocation.getContext(), response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(Map<String, String> context, Response response) {
        this.invocation.getInvocationStageTrace().finishHandlersResponse();
        ResponseHeader header = new ResponseHeader();
        header.setStatusCode(response.getStatusCode());
        header.setReasonPhrase(response.getReasonPhrase());
        header.setContext(context);
        header.setHeaders(response.getHeaders());
        ResponseRootSerializer bodySchema = this.operationProtobuf.findResponseRootSerializer(response.getStatusCode());
        Object body = response.getResult();
        if (response.isFailed()) {
            body = ((InvocationException)body).getErrorData();
        }
        try {
            Buffer respBuffer = HighwayCodec.encodeResponse(this.msgId, header, bodySchema, body);
            this.invocation.getInvocationStageTrace().finishServerFiltersResponse();
            this.connection.write(respBuffer.getByteBuf());
        }
        catch (Exception e) {
            String msg = String.format("encode response failed, %s, msgId=%d", this.invocation.getOperationMeta().getMicroserviceQualifiedName(), this.msgId);
            LOGGER.error(msg, (Throwable)e);
        }
        finally {
            if (this.invocation != null) {
                this.invocation.onFinish(response);
            }
        }
    }

    public void execute() {
        try {
            this.invocation = InvocationFactory.forProvider((Endpoint)this.endpoint, (OperationMeta)this.operationMeta, null);
            this.operationProtobuf = ProtobufManager.getOrCreateOperation((Invocation)this.invocation);
            this.invocation.onStart(null, this.start);
            this.invocation.getInvocationStageTrace().startSchedule();
            this.invocation.mergeContext(this.header.getContext());
            Holder<Boolean> qpsFlowControlReject = this.checkQpsFlowControl(this.operationMeta);
            if (((Boolean)qpsFlowControlReject.value).booleanValue()) {
                return;
            }
            this.operationMeta.getExecutor().execute(this::runInExecutor);
        }
        catch (Throwable e) {
            if (e instanceof RejectedExecutionException) {
                LOGGER.error("failed to schedule invocation, message={}, executor={}.", (Object)e.getMessage(), (Object)e.getClass().getName());
            }
            this.sendResponse(this.header.getContext(), Response.providerFailResp((Throwable)e));
        }
    }

    private Holder<Boolean> checkQpsFlowControl(OperationMeta operationMeta) {
        Holder qpsFlowControlReject = new Holder((Object)false);
        Handler providerQpsFlowControlHandler = operationMeta.getProviderQpsFlowControlHandler();
        if (null != providerQpsFlowControlHandler) {
            try {
                providerQpsFlowControlHandler.handle(this.invocation, response -> {
                    qpsFlowControlReject.value = true;
                    this.sendResponse(this.header.getContext(), response);
                });
            }
            catch (Exception e) {
                LOGGER.error("failed to execute ProviderQpsFlowControlHandler", (Throwable)e);
                qpsFlowControlReject.value = true;
                this.sendResponse(this.header.getContext(), Response.providerFailResp((Throwable)e));
            }
        }
        return qpsFlowControlReject;
    }
}

