/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.service.center.client.http.HttpRequest;
import org.apache.servicecomb.service.center.client.http.HttpResponse;
import org.apache.servicecomb.service.center.client.http.HttpTransport;
import org.apache.servicecomb.service.center.client.http.HttpTransportFactory;
import org.apache.servicecomb.service.center.client.http.TLSConfig;
import org.apache.servicecomb.service.center.client.http.TLSHttpsTransport;

public class ServiceCenterRawClient {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 30100;
    private static final String PROJECT_NAME = "default";
    private static final String V4_PREFIX = "v4";
    private static final String HEADER_TENANT_NAME = "x-domain-name";
    private static final String DEFAULT_HEADER_TENANT_NAME = "default";
    private String basePath;
    private String host;
    private int port;
    private String projectName;
    private String tenantName;
    private HttpTransport httpTransport;

    public ServiceCenterRawClient() {
        this(DEFAULT_HOST, 30100, "default", HttpTransportFactory.getDefaultHttpTransport(), "default");
    }

    private ServiceCenterRawClient(String host, int port, String projectName, HttpTransport httpTransport, String tenantName) {
        this.host = host;
        this.port = port;
        this.projectName = projectName;
        this.httpTransport = httpTransport;
        this.tenantName = tenantName;
        String hostLowercase = host.toLowerCase();
        if (!hostLowercase.startsWith("https://") && !hostLowercase.startsWith("http://")) {
            host = httpTransport instanceof TLSHttpsTransport ? "https://" + host : "http://" + host;
        }
        this.basePath = host + ":" + port + "/" + V4_PREFIX + "/" + projectName;
    }

    public HttpResponse getHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "GET");
    }

    public HttpResponse postHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "POST");
    }

    public HttpResponse putHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "PUT");
    }

    public HttpResponse deleteHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "DELETE");
    }

    private HttpResponse doHttpRequest(String url, Map<String, String> headers, String content, String method) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(HEADER_TENANT_NAME, this.tenantName);
        HttpRequest httpRequest = new HttpRequest(this.basePath + url, headers, content, method);
        return this.httpTransport.doRequest(httpRequest);
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 30100;
        private String projectName = "default";
        private String tenantName = "default";
        private HttpTransport httpTransport = HttpTransportFactory.getDefaultHttpTransport();

        public String getProjectName() {
            return this.projectName;
        }

        public Builder setProjectName(String projectName) {
            if (projectName == null) {
                projectName = "default";
            }
            this.projectName = projectName;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            if (port <= 0) {
                port = 30100;
            }
            this.port = port;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            if (host == null) {
                host = ServiceCenterRawClient.DEFAULT_HOST;
            }
            this.host = host;
            return this;
        }

        public HttpTransport getHttpTransport() {
            return this.httpTransport;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setTLSConf(TLSConfig tlsConfig) {
            this.httpTransport = new TLSHttpsTransport(tlsConfig);
            return this;
        }

        public Builder setTenantName(String tenantName) {
            if (tenantName == null) {
                tenantName = "default";
            }
            this.tenantName = tenantName;
            return this;
        }

        public ServiceCenterRawClient build() {
            return new ServiceCenterRawClient(this.host, this.port, this.projectName, this.httpTransport, this.tenantName);
        }
    }
}

