/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.kie.client.http;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.servicecomb.kie.client.http.HttpRequest;
import org.apache.servicecomb.kie.client.http.HttpResponse;
import org.apache.servicecomb.kie.client.http.HttpTransport;

public class HttpTransportImpl
implements HttpTransport {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_TENANT_NAME = "x-domain-name";
    protected HttpClient httpClient = HttpClients.createDefault();

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpResponse get(HttpRequest request) throws IOException {
        HttpGet httpGet = new HttpGet(request.getUrl());
        return this.doRequest((HttpUriRequest)httpGet);
    }

    @Override
    public HttpResponse post(HttpRequest request) throws IOException {
        HttpPost httpPost = new HttpPost(request.getUrl());
        if (request.getContent() != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(request.getContent(), "UTF-8"));
        }
        return this.doRequest((HttpUriRequest)httpPost);
    }

    @Override
    public HttpResponse put(HttpRequest request) throws IOException {
        HttpPut httpPut = new HttpPut(request.getUrl());
        if (request.getContent() != null) {
            httpPut.setEntity((HttpEntity)new StringEntity(request.getContent(), "UTF-8"));
        }
        return this.doRequest((HttpUriRequest)httpPut);
    }

    @Override
    public HttpResponse delete(HttpRequest request) throws IOException {
        HttpDelete httpDelete = new HttpDelete(request.getUrl());
        return this.doRequest((HttpUriRequest)httpDelete);
    }

    private HttpResponse doRequest(HttpUriRequest httpRequest) throws IOException {
        httpRequest.addHeader(HEADER_CONTENT_TYPE, "application/json");
        httpRequest.addHeader(HEADER_USER_AGENT, "kie-client/1.0.0");
        httpRequest.addHeader(HEADER_TENANT_NAME, "default");
        org.apache.http.HttpResponse response = this.httpClient.execute(httpRequest);
        int statusCode = response.getStatusLine().getStatusCode();
        String messgae = response.getStatusLine().getReasonPhrase();
        String context = null;
        if (response.getEntity() != null) {
            context = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        return new HttpResponse(statusCode, messgae, context);
    }
}

