/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;

public class RequestProtocolItemAccess
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerRequest request = accessLogEvent.getRoutingContext().request();
        if (null == request || null == request.version()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(this.getStringVersion(request.version()));
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        Invocation invocation = finishEvent.getInvocation();
        if (invocation == null || null == invocation.getEndpoint() || null == invocation.getEndpoint().getAddress() || !(invocation.getEndpoint().getAddress() instanceof URIEndpointObject) || !((URIEndpointObject)invocation.getEndpoint().getAddress()).isHttp2Enabled()) {
            builder.append("HTTP/1.1");
            return;
        }
        builder.append("HTTP/2.0");
    }

    private String getStringVersion(HttpVersion version) {
        switch (version) {
            case HTTP_2: {
                return "HTTP/2.0";
            }
            case HTTP_1_0: {
                return "HTTP/1.0";
            }
            case HTTP_1_1: {
                return "HTTP/1.1";
            }
        }
        return EMPTY_RESULT;
    }
}

