/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.springframework.util.StringUtils;

public class RequestHeaderItemAccess
implements AccessLogItem<RoutingContext> {
    public static final String RESULT_NOT_FOUND = "-";
    private final String varName;

    public RequestHeaderItemAccess(String varName) {
        this.varName = varName;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        MultiMap headers = accessLogEvent.getRoutingContext().request().headers();
        if (null == headers || StringUtils.isEmpty((Object)headers.get(this.varName))) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(headers.get(this.varName));
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent clientLogEvent, StringBuilder builder) {
        RestClientRequestImpl restRequestImpl = (RestClientRequestImpl)clientLogEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getRequest() || null == restRequestImpl.getRequest().headers() || StringUtils.isEmpty((Object)restRequestImpl.getRequest().headers().get(this.varName))) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(restRequestImpl.getRequest().headers().get(this.varName));
    }

    public String getVarName() {
        return this.varName;
    }
}

