/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;

public class RemoteHostItemAccess
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerRequest request = accessLogEvent.getRoutingContext().request();
        if (null == request || null == request.remoteAddress() || StringUtils.isEmpty((CharSequence)request.remoteAddress().host())) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(request.remoteAddress().host());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent clientLogEvent, StringBuilder builder) {
        Endpoint endpoint = clientLogEvent.getInvocation().getEndpoint();
        if (null == endpoint || null == endpoint.getAddress() || StringUtils.isEmpty((CharSequence)((URIEndpointObject)endpoint.getAddress()).getHostOrIp())) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(((URIEndpointObject)endpoint.getAddress()).getHostOrIp());
    }
}

