/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.kie.archaius.sources.KieConfigurationSourceImpl;
import org.apache.servicecomb.config.kie.client.ConnFailEvent;
import org.apache.servicecomb.config.kie.client.ConnSuccEvent;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.config.kie.client.KieUtil;
import org.apache.servicecomb.config.kie.client.KieWatcher;
import org.apache.servicecomb.config.kie.model.KVResponse;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.AddressResolverConfig;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieClient.class);
    private ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("org.apache.servicecomb.config.kie");
        thread.setDaemon(true);
        return thread;
    });
    private static final long TIME_OUT = 10000L;
    private static AtomicBoolean IS_FIRST_PULL = new AtomicBoolean(true);
    private static final int LONG_POLLING_WAIT_TIME = 30;
    private static final int SOCKET_TIMOUT = 50;
    private static final KieConfig KIE_CONFIG = KieConfig.INSTANCE;
    private final int refreshInterval = KIE_CONFIG.getRefreshInterval();
    private final int firstRefreshInterval = KIE_CONFIG.getFirstRefreshInterval();
    private final boolean enableLongPolling = KIE_CONFIG.enableLongPolling();
    private final String serviceUri = KIE_CONFIG.getServerUri();
    private ClientPoolManager<HttpClientWithContext> clientMgr;

    public KieClient(KieConfigurationSourceImpl.UpdateHandler updateHandler) {
        KieWatcher.INSTANCE.setUpdateHandler(updateHandler);
    }

    public void refreshKieConfig() {
        try {
            this.deployConfigClient();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (this.enableLongPolling) {
            this.EXECUTOR.execute(new ConfigRefresh(this.serviceUri));
        } else {
            this.EXECUTOR.scheduleWithFixedDelay(new ConfigRefresh(this.serviceUri), this.firstRefreshInterval, this.refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void deployConfigClient() throws InterruptedException {
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setAddressResolverOptions(AddressResolverConfig.getAddressResover((String)"kie.consumer", (Configuration)KieConfig.getFinalConfig()));
        Vertx vertx = VertxUtils.getOrCreateVertxByName((String)"kie", (VertxOptions)vertxOptions);
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setKeepAlive(true);
        httpClientOptions.setIdleTimeout(50);
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptions));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)1);
        VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
    }

    public void destroy() {
        if (this.EXECUTOR != null) {
            this.EXECUTOR.shutdown();
            this.EXECUTOR = null;
        }
    }

    class ConfigRefresh
    implements Runnable {
        private final String serviceUri;

        ConfigRefresh(String serviceUris) {
            this.serviceUri = serviceUris;
        }

        @Override
        public void run() {
            try {
                this.refreshConfig();
            }
            catch (Throwable e) {
                LOGGER.error("client refresh thread exception ", e);
            }
        }

        void refreshConfig() {
            String path = "/v1/" + KieConfig.INSTANCE.getDomainName() + "/kie/kv?label=app:" + KieConfig.INSTANCE.getAppName();
            if (KieClient.this.enableLongPolling && !IS_FIRST_PULL.get()) {
                path = path + "&wait=30s";
            } else {
                IS_FIRST_PULL.compareAndSet(true, false);
            }
            String finalPath = path;
            ((HttpClientWithContext)KieClient.this.clientMgr.findThreadBindClientPool()).runOnContext(client -> {
                IpPort ipPort = NetUtils.parseIpPortFromURI((String)this.serviceUri);
                HttpClientRequest request = client.get(ipPort.getPort(), ipPort.getHostOrIp(), finalPath, rsp -> {
                    if (rsp.statusCode() == HttpResponseStatus.OK.code()) {
                        rsp.bodyHandler(buf -> {
                            try {
                                Map<String, Object> resMap = KieUtil.getConfigByLabel((KVResponse)JsonUtils.OBJ_MAPPER.readValue(buf.toString(), KVResponse.class));
                                KieWatcher.INSTANCE.refreshConfigItems(resMap);
                                EventManager.post((Object)new ConnSuccEvent());
                            }
                            catch (IOException e) {
                                EventManager.post((Object)new ConnFailEvent("config update result parse fail " + e.getMessage()));
                                LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)this.serviceUri, (Object)e.getMessage());
                            }
                        });
                    } else if (rsp.statusCode() == 404) {
                        EventManager.post((Object)new ConnSuccEvent());
                    } else {
                        EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                        LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)this.serviceUri, (Object)rsp.statusMessage());
                    }
                    if (KieClient.this.enableLongPolling) {
                        KieClient.this.EXECUTOR.execute(this);
                    }
                }).setTimeout(10000L);
                request.exceptionHandler(e -> {
                    EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                    LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)this.serviceUri, (Object)e.getMessage());
                });
                request.end();
            });
        }
    }
}

