/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.definition;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class PojoConsumerMeta {
    private MicroserviceReferenceConfig microserviceReferenceConfig;
    private Class<?> consumerIntf;
    private SchemaMeta schemaMeta;
    private Map<String, PojoConsumerOperationMeta> operationMetas = new HashMap<String, PojoConsumerOperationMeta>();

    public PojoConsumerMeta(MicroserviceReferenceConfig microserviceReferenceConfig, SwaggerConsumer swaggerConsumer, SchemaMeta schemaMeta) {
        this.microserviceReferenceConfig = microserviceReferenceConfig;
        this.consumerIntf = swaggerConsumer.getConsumerIntf();
        this.schemaMeta = schemaMeta;
        SwaggerGenerator intfSwaggerGenerator = SwaggerGenerator.create(this.consumerIntf);
        intfSwaggerGenerator.scanClassAnnotation();
        for (SwaggerConsumerOperation swaggerConsumerOperation : swaggerConsumer.getOperations().values()) {
            String operationId = swaggerConsumerOperation.getSwaggerOperation().getOperationId();
            OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
            OperationGenerator intfOperationGenerator = intfSwaggerGenerator.createOperationGenerator(swaggerConsumerOperation.getConsumerMethod());
            intfOperationGenerator.generateResponse();
            PojoConsumerOperationMeta pojoConsumerOperationMeta = new PojoConsumerOperationMeta(this, operationMeta, swaggerConsumerOperation, intfSwaggerGenerator.getSwagger(), intfOperationGenerator.getOperation());
            this.operationMetas.put(swaggerConsumerOperation.getSchemaOperationId(), pojoConsumerOperationMeta);
        }
    }

    public MicroserviceReferenceConfig getMicroserviceReferenceConfig() {
        return this.microserviceReferenceConfig;
    }

    public Class<?> getConsumerIntf() {
        return this.consumerIntf;
    }

    public boolean isExpired() {
        return this.microserviceReferenceConfig.isExpired();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public PojoConsumerOperationMeta findOperationMeta(String consumerMethodName) {
        return this.operationMetas.get(consumerMethodName);
    }
}

