/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.producer;

import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.ProducerProvider;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerProviderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerProviderManager.class);
    private List<ProducerProvider> producerProviderList = new ArrayList<ProducerProvider>(SPIServiceUtils.getOrLoadSortedService(ProducerProvider.class));
    private SCBEngine scbEngine;
    private List<ProducerMeta> producerMetas = new ArrayList<ProducerMeta>();

    public ProducerProviderManager(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
    }

    public List<ProducerProvider> getProducerProviderList() {
        return this.producerProviderList;
    }

    public void init() {
        this.regsiterProducerMetas(this.producerMetas);
        for (ProducerProvider provider : this.producerProviderList) {
            List<ProducerMeta> producerMetas = provider.init();
            if (producerMetas == null) {
                LOGGER.warn("ProducerProvider {} not provide any producer.", (Object)provider.getClass().getName());
                continue;
            }
            this.regsiterProducerMetas(producerMetas);
        }
    }

    public void addProducerMeta(String schemaId, Object instance) {
        this.addProducerMeta(new ProducerMeta(schemaId, instance));
    }

    public void addProducerMeta(ProducerMeta producerMeta) {
        this.producerMetas.add(producerMeta);
    }

    private void regsiterProducerMetas(List<ProducerMeta> producerMetas) {
        for (ProducerMeta producerMeta : producerMetas) {
            this.registerSchema(producerMeta.getSchemaId(), producerMeta.getInstance());
        }
    }

    public SchemaMeta registerSchema(String schemaId, Object instance) {
        MicroserviceMeta producerMicroserviceMeta = this.scbEngine.getProducerMicroserviceMeta();
        Swagger swagger = this.scbEngine.getSwaggerLoader().loadLocalSwagger(producerMicroserviceMeta.getAppId(), producerMicroserviceMeta.getShortName(), schemaId);
        SwaggerProducer swaggerProducer = this.scbEngine.getSwaggerEnvironment().createProducer(instance, swagger);
        swagger = swaggerProducer.getSwagger();
        this.registerUrlPrefixToSwagger(swagger);
        SchemaMeta schemaMeta = producerMicroserviceMeta.registerSchemaMeta(schemaId, swagger);
        schemaMeta.putExtData("scb_swagger-producer", swaggerProducer);
        Executor reactiveExecutor = this.scbEngine.getExecutorManager().findExecutorById("servicecomb.executor.reactive");
        for (SwaggerProducerOperation producerOperation : swaggerProducer.getAllOperations()) {
            OperationMeta operationMeta = schemaMeta.ensureFindOperation(producerOperation.getOperationId());
            operationMeta.setSwaggerProducerOperation(producerOperation);
            if (!CompletableFuture.class.equals(producerOperation.getProducerMethod().getReturnType())) continue;
            operationMeta.setExecutor(this.scbEngine.getExecutorManager().findExecutor(operationMeta, reactiveExecutor));
        }
        return schemaMeta;
    }

    private void registerUrlPrefixToSwagger(Swagger swagger) {
        String urlPrefix = System.getProperty("urlPrefix");
        if (!StringUtils.isEmpty((CharSequence)urlPrefix) && !swagger.getBasePath().startsWith(urlPrefix) && DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.registerUrlPrefix", false).get()) {
            LOGGER.info("Add swagger base path prefix for {} with {}", (Object)swagger.getBasePath(), (Object)urlPrefix);
            swagger.setBasePath(urlPrefix + swagger.getBasePath());
        }
    }
}

