/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.swagger.invocation.response.ResponsesMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerUtils.class);

    public static <T> T syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        return (T)InvokerUtils.syncInvoke(invocation);
    }

    public static void reactiveInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        Invocation invocation = InvokerUtils.createInvocation(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, responseType);
        InvokerUtils.reactiveInvoke(invocation, asyncResp);
    }

    public static <T> T syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType);
    }

    public static void reactiveInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType, AsyncResponse asyncResp) {
        InvokerUtils.reactiveInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments, responseType, asyncResp);
    }

    private static Invocation createInvocation(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments, Type responseType) {
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().createMicroserviceReferenceConfig(microserviceName, microserviceVersion);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(schemaId);
        OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(transport, operationMeta);
        Invocation invocation = InvocationFactory.forConsumer(referenceConfig, operationMeta, swaggerArguments);
        InvokerUtils.setInvocationResponseType(invocation, responseType);
        return invocation;
    }

    private static void setInvocationResponseType(Invocation invocation, Type responseType) {
        if (responseType != null) {
            ResponsesMeta responsesMeta = new ResponsesMeta();
            invocation.getOperationMeta().getResponsesMeta().cloneTo(responsesMeta);
            responsesMeta.getResponseMap().put(Response.Status.OK.getStatusCode(), TypeFactory.defaultInstance().constructType(responseType));
            invocation.setResponsesMeta(responsesMeta);
        }
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, null, null, schemaId, operationId, swaggerArguments);
    }

    @Deprecated
    public static Object syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationId, Map<String, Object> swaggerArguments) {
        return InvokerUtils.syncInvoke(microserviceName, microserviceVersion, transport, schemaId, operationId, swaggerArguments, null);
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSuccessed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        try {
            invocation.onStart(null, System.nanoTime());
            SyncResponseExecutor respExecutor = new SyncResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.getInvocationStageTrace().startHandlersRequest();
            invocation.next(respExecutor::setResponse);
            Response response = respExecutor.waitResponse();
            invocation.getInvocationStageTrace().finishHandlersResponse();
            invocation.onFinish(response);
            return response;
        }
        catch (Throwable e) {
            String msg = String.format("invoke failed, %s", invocation.getOperationMeta().getMicroserviceQualifiedName());
            LOGGER.error(msg, e);
            LOGGER.error("invocation type: {}, handler chain: {}", (Object)invocation.getInvocationType(), invocation.getHandlerChain());
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            return response;
        }
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        try {
            invocation.onStart(null, System.nanoTime());
            invocation.setSync(false);
            ReactiveResponseExecutor respExecutor = new ReactiveResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.getInvocationStageTrace().startHandlersRequest();
            invocation.next(ar -> {
                ContextUtils.setInvocationContext((InvocationContext)invocation.getParentContext());
                try {
                    invocation.getInvocationStageTrace().finishHandlersResponse();
                    invocation.onFinish(ar);
                    asyncResp.handle(ar);
                }
                finally {
                    ContextUtils.removeInvocationContext();
                }
            });
        }
        catch (Throwable e) {
            invocation.getInvocationStageTrace().finishHandlersResponse();
            Response response = Response.createConsumerFail((Throwable)e);
            invocation.onFinish(response);
            LOGGER.error("invoke failed, {}", (Object)invocation.getOperationMeta().getMicroserviceQualifiedName());
            asyncResp.handle(response);
        }
    }
}

