/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import com.google.common.eventbus.Subscribe;
import io.swagger.models.Swagger;
import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.SubscriberOrder;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.event.CreateMicroserviceEvent;
import org.apache.servicecomb.serviceregistry.event.CreateMicroserviceVersionEvent;
import org.apache.servicecomb.serviceregistry.event.DestroyMicroserviceEvent;

public class ServiceRegistryListener {
    private final SCBEngine scbEngine;

    public ServiceRegistryListener(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
        scbEngine.getEventBus().register((Object)this);
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroservice(CreateMicroserviceEvent event) {
        MicroserviceVersions microserviceVersions = event.getMicroserviceVersions();
        microserviceVersions.getVendorExtensions().put((Object)"scb_microservice_versions_meta", (Object)new ConsumerMicroserviceVersionsMeta(this.scbEngine, microserviceVersions));
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onDestroyMicroservice(DestroyMicroserviceEvent event) {
        MicroserviceVersions microserviceVersions = event.getMicroserviceVersions();
        MicroserviceVersionsMeta microserviceVersionsMeta = (MicroserviceVersionsMeta)microserviceVersions.getVendorExtensions().get((Object)"scb_microservice_versions_meta");
        microserviceVersionsMeta.destroy();
    }

    @EnableExceptionPropagation
    @SubscriberOrder(value=-1000)
    @Subscribe
    public void onCreateMicroserviceVersion(CreateMicroserviceVersionEvent event) {
        boolean isServiceCenter;
        MicroserviceVersion microserviceVersion = event.getMicroserviceVersion();
        Microservice microservice = microserviceVersion.getMicroservice();
        String microserviceName = microserviceVersion.getMicroserviceName();
        List consumerHandlerChain = (List)this.scbEngine.getConsumerHandlerManager().getOrCreate(microserviceName);
        List producerHandlerChain = (List)this.scbEngine.getProducerHandlerManager().getOrCreate(microserviceName);
        MicroserviceMeta microserviceMeta = new MicroserviceMeta(this.scbEngine, microserviceName, consumerHandlerChain, producerHandlerChain);
        MicroserviceVersions microserviceVersions = microserviceVersion.getMicroserviceVersions();
        microserviceMeta.setMicroserviceVersionsMeta((MicroserviceVersionsMeta)CoreMetaUtils.getMicroserviceVersionsMeta(microserviceVersions));
        boolean bl = isServiceCenter = "default".equals(microservice.getAppId()) && "SERVICECENTER".equals(microservice.getServiceName());
        if (!isServiceCenter) {
            for (String schemaId : microservice.getSchemas()) {
                Swagger swagger = this.scbEngine.getSwaggerLoader().loadSwagger(microservice, schemaId);
                microserviceMeta.registerSchemaMeta(schemaId, swagger);
            }
        }
        microserviceMeta.putExtData("scb_microservice_version", microserviceVersion);
        microserviceVersion.getVendorExtensions().put((Object)"scb_microservice_meta", (Object)microserviceMeta);
    }

    public void destroy() {
        this.scbEngine.getEventBus().unregister((Object)this);
    }
}

