/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema;

import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class MessageAsFieldSchema<T>
extends FieldSchema<T> {
    protected final SchemaEx<Object> schema;
    protected final Getter<T, Object> getter;
    protected final Setter<T, Object> setter;

    public MessageAsFieldSchema(Field protoField, PropertyDescriptor propertyDescriptor, SchemaEx<Object> schema) {
        super(protoField, propertyDescriptor.getJavaType());
        this.schema = schema;
        this.getter = (Getter)propertyDescriptor.getGetter();
        this.setter = (Setter)propertyDescriptor.getSetter();
    }

    @Override
    public final void getAndWriteTo(OutputEx output, T message) throws IOException {
        Object value = this.getter.get(message);
        if (value == null) {
            return;
        }
        output.writeObject(this.tag, this.tagSize, value, this.schema);
    }

    @Override
    public final void writeTo(OutputEx output, Object value) throws IOException {
        output.writeObject(this.tag, this.tagSize, value, this.schema);
    }

    @Override
    public final int mergeFrom(InputEx input, T message) throws IOException {
        Object value = this.getter.get(message);
        if (value == null) {
            value = this.schema.newMessage();
            this.setter.set(message, value);
        }
        input.mergeObject(value, this.schema);
        return input.readFieldNumber();
    }
}

