/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.filter.EndpointDiscoveryFilter;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.cache.CacheEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDiscoveryFilter
extends EndpointDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerDiscoveryFilter.class);

    protected Object createEndpoint(String transportName, String endpoint, MicroserviceInstance instance) {
        Transport transport = SCBEngine.getInstance().getTransportManager().findTransport(transportName);
        if (transport == null) {
            LOGGER.info("not deployed transport {}, ignore {}.", (Object)transportName, (Object)endpoint);
            return null;
        }
        return new ServiceCombServer(transport, new CacheEndpoint(endpoint, instance));
    }
}

