/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.servicecomb.foundation.common.concurrency.SuppressedRunnableWrapper;
import org.apache.servicecomb.serviceregistry.Features;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.registry.BasePath;
import org.apache.servicecomb.serviceregistry.api.registry.Framework;
import org.apache.servicecomb.serviceregistry.api.registry.FrameworkVersions;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceFactory;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.StaticMicroserviceVersions;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceNameParser;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheKey;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheRefreshedEvent;
import org.apache.servicecomb.serviceregistry.registry.cache.RefreshableServiceRegistryCache;
import org.apache.servicecomb.serviceregistry.registry.cache.ServiceRegistryCache;
import org.apache.servicecomb.serviceregistry.task.MicroserviceServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.ServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.event.RecoveryEvent;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;
import org.apache.servicecomb.serviceregistry.task.event.ShutdownEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceRegistry.class);
    private Features features = new Features();
    private MicroserviceFactory microserviceFactory = new MicroserviceFactory();
    protected EventBus eventBus;
    protected MicroserviceDefinition microserviceDefinition;
    protected Microservice microservice;
    protected ServiceRegistryClient srClient;
    protected ServiceRegistryConfig serviceRegistryConfig;
    protected ServiceCenterTask serviceCenterTask;
    protected ExecutorService executorService = MoreExecutors.newDirectExecutorService();
    private String name;
    RefreshableServiceRegistryCache serviceRegistryCache;

    public AbstractServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        this.setName(serviceRegistryConfig.getRegistryName());
        this.eventBus = eventBus;
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceDefinition = microserviceDefinition;
        this.microservice = this.microserviceFactory.create(microserviceDefinition);
    }

    @Override
    public void init() {
        if (this.srClient == null) {
            this.srClient = this.createServiceRegistryClient();
            this.eventBus.register((Object)this.srClient);
        }
        this.createServiceCenterTask();
        this.eventBus.register((Object)this);
        this.initCache();
    }

    private void initCache() {
        this.serviceRegistryCache = new RefreshableServiceRegistryCache(this.microservice, this.srClient);
        this.serviceRegistryCache.setCacheRefreshedWatcher(caches -> this.eventBus.post((Object)new MicroserviceCacheRefreshedEvent((List<MicroserviceCache>)caches)));
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Set<String> getCombinedMicroserviceNames() {
        return this.microserviceDefinition.getCombinedFrom();
    }

    @Override
    public ServiceRegistryClient getServiceRegistryClient() {
        return this.srClient;
    }

    public void setServiceRegistryClient(ServiceRegistryClient serviceRegistryClient) {
        this.srClient = serviceRegistryClient;
    }

    @Override
    public String getAppId() {
        return this.microservice.getAppId();
    }

    protected abstract ServiceRegistryClient createServiceRegistryClient();

    @Override
    public void run() {
        this.loadStaticConfiguration();
        this.loadFrameworkVersions();
        this.serviceCenterTask.init();
    }

    private void loadFrameworkVersions() {
        Framework framework = new Framework();
        framework.setName("servicecomb-java-chassis");
        framework.setVersion(FrameworkVersions.allVersions());
        this.microservice.setFramework(framework);
        this.microservice.setRegisterBy("SDK");
    }

    private void loadStaticConfiguration() {
        List<BasePath> paths = this.microservice.getPaths();
        for (BasePath path : paths) {
            if (path.getProperty() == null) {
                path.setProperty(new HashMap<String, String>());
            }
            path.getProperty().put("checksession", "false");
        }
    }

    private void createServiceCenterTask() {
        MicroserviceServiceCenterTask task = new MicroserviceServiceCenterTask(this.eventBus, this.serviceRegistryConfig, this.srClient, this.microservice);
        this.serviceCenterTask = new ServiceCenterTask(this.eventBus, this.serviceRegistryConfig.getHeartbeatInterval(), this.serviceRegistryConfig.getResendHeartBeatTimes(), task);
    }

    public boolean unregisterInstance() {
        MicroserviceInstance microserviceInstance = this.microservice.getInstance();
        if (microserviceInstance.getInstanceId() == null || microserviceInstance.getServiceId() == null) {
            return true;
        }
        boolean result = this.srClient.unregisterMicroserviceInstance(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId());
        if (!result) {
            LOGGER.error("Unregister microservice instance failed. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
            return false;
        }
        LOGGER.info("Unregister microservice instance success. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
        return true;
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        MicroserviceInstances instances = this.findServiceInstances(appId, serviceName, versionRule, null);
        if (instances == null || instances.isMicroserviceNotExist()) {
            return null;
        }
        return instances.getInstancesResponse().getInstances();
    }

    @Override
    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule, String revision) {
        MicroserviceCache microserviceCache = this.serviceRegistryCache.findServiceCache(MicroserviceCacheKey.builder().serviceName(serviceName).appId(appId).env(this.microservice.getEnvironment()).build());
        return RegistryUtils.convertCacheToMicroserviceInstances(microserviceCache);
    }

    @Override
    public MicroserviceCache findMicroserviceCache(MicroserviceCacheKey microserviceCacheKey) {
        return this.serviceRegistryCache.findServiceCache(microserviceCacheKey);
    }

    @Override
    public boolean updateMicroserviceProperties(Map<String, String> properties) {
        boolean success = this.srClient.updateMicroserviceProperties(this.microservice.getServiceId(), properties);
        if (success) {
            this.microservice.setProperties(properties);
        }
        return success;
    }

    @Override
    public boolean updateInstanceProperties(Map<String, String> instanceProperties) {
        MicroserviceInstance microserviceInstance = this.microservice.getInstance();
        boolean success = this.srClient.updateInstanceProperties(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId(), instanceProperties);
        if (success) {
            microserviceInstance.setProperties(instanceProperties);
        }
        return success;
    }

    @Override
    public Microservice getRemoteMicroservice(String microserviceId) {
        return this.srClient.getMicroservice(microserviceId);
    }

    @Override
    public Microservice getAggregatedRemoteMicroservice(String microserviceId) {
        return this.srClient.getAggregatedMicroservice(microserviceId);
    }

    @Override
    public Microservice getMicroservice() {
        return this.microservice;
    }

    @Override
    public MicroserviceInstance getMicroserviceInstance() {
        return this.microservice.getInstance();
    }

    @Override
    public void destroy() {
        this.eventBus.post((Object)new ShutdownEvent());
        this.unregisterInstance();
    }

    @Override
    public void registerMicroserviceMapping(String microserviceName, String version, List<MicroserviceInstance> instances, Class<?> schemaIntfCls) {
        MicroserviceNameParser parser = new MicroserviceNameParser(this.microservice.getAppId(), microserviceName);
        MicroserviceManager microserviceManager = RegistryUtils.getAppManager().getOrCreateMicroserviceManager(parser.getAppId());
        microserviceManager.getVersionsByName().computeIfAbsent(microserviceName, svcName -> new StaticMicroserviceVersions(RegistryUtils.getAppManager(), parser.getAppId(), microserviceName).init(schemaIntfCls, version, instances));
    }

    @Override
    public void registerMicroserviceMappingByEndpoints(String microserviceName, String version, List<String> endpoints, Class<?> schemaIntfCls) {
        ArrayList<MicroserviceInstance> microserviceInstances = new ArrayList<MicroserviceInstance>();
        for (String endpoint : endpoints) {
            MicroserviceInstance instance = new MicroserviceInstance();
            instance.setEndpoints(Collections.singletonList(endpoint));
            microserviceInstances.add(instance);
        }
        this.registerMicroserviceMapping(microserviceName, version, microserviceInstances, schemaIntfCls);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        RegistryUtils.validateRegistryName(name);
        this.name = name;
    }

    public ServiceRegistryCache getServiceRegistryCache() {
        return this.serviceRegistryCache;
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        LOGGER.info("service center task is shutdown.");
        this.executorService.shutdownNow();
    }

    @Subscribe
    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        this.executorService.execute((Runnable)new SuppressedRunnableWrapper(() -> {
            this.serviceRegistryCache.onMicroserviceInstanceChanged(changedEvent);
            RegistryUtils.getAppManager().onMicroserviceInstanceChanged(changedEvent);
        }));
    }

    @Subscribe
    public void serviceRegistryRecovery(RecoveryEvent event) {
        this.executorService.execute(() -> {
            this.serviceRegistryCache.forceRefreshCache();
            RegistryUtils.getAppManager().pullInstances();
        });
    }

    @Subscribe
    public void onSafeModeChanged(SafeModeChangeEvent modeChangeEvent) {
        this.executorService.execute(() -> {
            LOGGER.warn("receive SafeModeChangeEvent, current mode={}", (Object)modeChangeEvent.getCurrentMode());
            this.serviceRegistryCache.onSafeModeChanged(modeChangeEvent);
            RegistryUtils.getAppManager().onSafeModeChanged(modeChangeEvent);
        });
    }
}

