/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.serviceregistry.client.http.AbstractClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClientPool
extends AbstractClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketClientPool.class);
    public static final WebsocketClientPool INSTANCE = new WebsocketClientPool();

    private WebsocketClientPool() {
        super(ServiceRegistryConfig.INSTANCE);
    }

    WebsocketClientPool(ServiceRegistryConfig serviceRegistryConfig) {
        super(serviceRegistryConfig);
    }

    @Override
    protected boolean isWorker() {
        return true;
    }

    @Override
    protected HttpClientOptions getHttpClientOptionsFromConfigurations(ServiceRegistryConfig serviceRegistryConfig) {
        HttpVersion ver = serviceRegistryConfig.getHttpVersion();
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setProtocolVersion(ver);
        httpClientOptions.setConnectTimeout(serviceRegistryConfig.getConnectionTimeout());
        httpClientOptions.setIdleTimeout(serviceRegistryConfig.getIdleWatchTimeout());
        if (ver == HttpVersion.HTTP_2) {
            LOGGER.debug("service center ws client protocol version is HTTP/2");
            httpClientOptions.setHttp2ClearTextUpgrade(false);
        }
        if (serviceRegistryConfig.isSsl()) {
            LOGGER.debug("service center ws client performs requests over TLS");
            VertxTLSBuilder.buildHttpClientOptions((String)serviceRegistryConfig.getSslConfigTag(), (HttpClientOptions)httpClientOptions);
        }
        return httpClientOptions;
    }
}

