/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.ProxyOptions;
import org.apache.servicecomb.foundation.common.encrypt.Encryptions;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.serviceregistry.client.http.AbstractClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientPool
extends AbstractClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientPool.class);
    public static final HttpClientPool INSTANCE = new HttpClientPool();

    private HttpClientPool() {
        super(ServiceRegistryConfig.INSTANCE);
    }

    HttpClientPool(ServiceRegistryConfig serviceRegistryConfig) {
        super(serviceRegistryConfig);
    }

    @Override
    protected boolean isWorker() {
        return false;
    }

    @Override
    protected HttpClientOptions getHttpClientOptionsFromConfigurations(ServiceRegistryConfig serviceRegistryConfig) {
        HttpVersion ver = serviceRegistryConfig.getHttpVersion();
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setProtocolVersion(ver);
        httpClientOptions.setConnectTimeout(serviceRegistryConfig.getConnectionTimeout());
        httpClientOptions.setIdleTimeout(serviceRegistryConfig.getIdleConnectionTimeout());
        if (serviceRegistryConfig.isProxyEnable().booleanValue()) {
            ProxyOptions proxy = new ProxyOptions();
            proxy.setHost(serviceRegistryConfig.getProxyHost());
            proxy.setPort(serviceRegistryConfig.getProxyPort());
            proxy.setUsername(serviceRegistryConfig.getProxyUsername());
            proxy.setPassword(Encryptions.decode((String)serviceRegistryConfig.getProxyPasswd(), (String)serviceRegistryConfig.getProxyConfigTag()));
            httpClientOptions.setProxyOptions(proxy);
        }
        if (ver == HttpVersion.HTTP_2) {
            LOGGER.debug("service center client protocol version is HTTP/2");
            httpClientOptions.setHttp2ClearTextUpgrade(false);
        }
        if (serviceRegistryConfig.isSsl()) {
            LOGGER.debug("service center client performs requests over TLS");
            VertxTLSBuilder.buildHttpClientOptions((String)serviceRegistryConfig.getSslConfigTag(), (HttpClientOptions)httpClientOptions);
        }
        return httpClientOptions;
    }
}

