/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.serviceregistry.cache.CacheEndpoint;
import org.apache.servicecomb.serviceregistry.cache.InstanceCache;
import org.apache.servicecomb.serviceregistry.cache.InstanceCacheManager;
import org.apache.servicecomb.serviceregistry.cache.InstanceCacheManagerNew;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpPortManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpPortManager.class);
    private ServiceRegistryConfig serviceRegistryConfig;
    InstanceCacheManager instanceCacheManager;
    private String defaultTransport = "rest";
    private ArrayList<IpPort> defaultIpPort;
    private AtomicInteger currentAvailableIndex;
    private boolean autoDiscoveryInited = false;
    private int maxRetryTimes;

    public void setAutoDiscoveryInited(boolean autoDiscoveryInited) {
        this.autoDiscoveryInited = autoDiscoveryInited;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public IpPortManager(ServiceRegistryConfig serviceRegistryConfig) {
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.instanceCacheManager = new InstanceCacheManagerNew(new AppManager());
        this.defaultTransport = serviceRegistryConfig.getTransport();
        this.defaultIpPort = serviceRegistryConfig.getIpPort();
        if (this.defaultIpPort.isEmpty()) {
            throw new IllegalArgumentException("Service center address is required to start the application.");
        }
        int initialIndex = new Random().nextInt(this.defaultIpPort.size());
        this.currentAvailableIndex = new AtomicInteger(initialIndex);
        this.maxRetryTimes = this.defaultIpPort.size();
    }

    public void initAutoDiscovery() {
        if (!this.autoDiscoveryInited && this.serviceRegistryConfig.isRegistryAutoDiscovery()) {
            InstanceCache cache = this.instanceCacheManager.getOrCreate("default", "SERVICECENTER", "latest");
            if (cache.getInstanceMap().size() > 0) {
                this.setAutoDiscoveryInited(true);
            } else {
                this.setAutoDiscoveryInited(false);
            }
        }
    }

    public IpPort getNextAvailableAddress(IpPort failedIpPort) {
        int currentIndex = this.currentAvailableIndex.get();
        IpPort current = this.getAvailableAddress(currentIndex);
        if (current.equals((Object)failedIpPort)) {
            this.currentAvailableIndex.compareAndSet(currentIndex, currentIndex + 1);
            current = this.getAvailableAddress();
        }
        LOGGER.info("Change service center address from {} to {}", (Object)failedIpPort.toString(), (Object)current.toString());
        return current;
    }

    public IpPort getAvailableAddress() {
        return this.getAvailableAddress(this.currentAvailableIndex.get());
    }

    private IpPort getAvailableAddress(int index) {
        if (index < this.defaultIpPort.size()) {
            return this.defaultIpPort.get(index);
        }
        List<CacheEndpoint> endpoints = this.getDiscoveredIpPort();
        if (endpoints == null || index >= this.defaultIpPort.size() + endpoints.size()) {
            this.currentAvailableIndex.set(0);
            return this.defaultIpPort.get(0);
        }
        this.maxRetryTimes = this.defaultIpPort.size() + endpoints.size();
        CacheEndpoint nextEndpoint = endpoints.get(index - this.defaultIpPort.size());
        return new URIEndpointObject(nextEndpoint.getEndpoint());
    }

    private List<CacheEndpoint> getDiscoveredIpPort() {
        if (!this.autoDiscoveryInited || !this.serviceRegistryConfig.isRegistryAutoDiscovery()) {
            return null;
        }
        InstanceCache instanceCache = this.instanceCacheManager.getOrCreate("default", "SERVICECENTER", "latest");
        return instanceCache.getOrCreateTransportMap().get(this.defaultTransport);
    }
}

