/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import org.apache.servicecomb.foundation.common.utils.AbstractRestObjectMapper;

public class RestObjectMapper
extends AbstractRestObjectMapper {
    private static final long serialVersionUID = -8158869347066287575L;
    private static final JavaType STRING_JAVA_TYPE = TypeFactory.defaultInstance().constructType(String.class);

    public RestObjectMapper() {
        this.setDateFormat((DateFormat)new ISO8601DateFormat(){
            private static final long serialVersionUID = 7798938088541203312L;

            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                String value = ISO8601Utils.format((Date)date, (boolean)true);
                toAppendTo.append(value);
                return toAppendTo;
            }
        });
        this.getFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        this.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        this.registerModule((Module)module);
        this.registerModule((Module)new JavaTimeModule());
    }

    @Override
    public String convertToString(Object value) throws Exception {
        return (String)this.convertValue(value, STRING_JAVA_TYPE);
    }

    public <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        return (T)super.convertValue(fromValue, toValueType);
    }

    private static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        private JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.getMap());
        }
    }
}

