/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.servicecomb.serviceregistry.Features;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.registry.BasePath;
import org.apache.servicecomb.serviceregistry.api.registry.Framework;
import org.apache.servicecomb.serviceregistry.api.registry.FrameworkVersions;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceFactory;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.cache.InstanceCacheManager;
import org.apache.servicecomb.serviceregistry.cache.InstanceCacheManagerNew;
import org.apache.servicecomb.serviceregistry.client.IpPortManager;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.StaticMicroserviceVersions;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceNameParser;
import org.apache.servicecomb.serviceregistry.swagger.SwaggerLoader;
import org.apache.servicecomb.serviceregistry.task.MicroserviceServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.ServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.event.RecoveryEvent;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;
import org.apache.servicecomb.serviceregistry.task.event.ShutdownEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceRegistry.class);
    private Features features = new Features();
    private MicroserviceFactory microserviceFactory = new MicroserviceFactory();
    protected EventBus eventBus;
    protected MicroserviceDefinition microserviceDefinition;
    protected Microservice microservice;
    protected AppManager appManager;
    protected InstanceCacheManager instanceCacheManager;
    protected IpPortManager ipPortManager;
    protected ServiceRegistryClient srClient;
    protected ServiceRegistryConfig serviceRegistryConfig;
    protected ServiceCenterTask serviceCenterTask;
    protected SwaggerLoader swaggerLoader = new SwaggerLoader(this);
    protected ExecutorService executorService = MoreExecutors.newDirectExecutorService();

    public AbstractServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        this.eventBus = eventBus;
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceDefinition = microserviceDefinition;
        this.microservice = this.microserviceFactory.create(microserviceDefinition);
    }

    @Override
    public void init() {
        this.appManager = new AppManager(this);
        this.instanceCacheManager = new InstanceCacheManagerNew(this.appManager);
        this.ipPortManager = new IpPortManager(this.serviceRegistryConfig, this.instanceCacheManager);
        if (this.srClient == null) {
            this.srClient = this.createServiceRegistryClient();
        }
        this.createServiceCenterTask();
        this.eventBus.register((Object)this);
    }

    @Override
    public SwaggerLoader getSwaggerLoader() {
        return this.swaggerLoader;
    }

    @Override
    public AppManager getAppManager() {
        return this.appManager;
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Set<String> getCombinedMicroserviceNames() {
        return this.microserviceDefinition.getCombinedFrom();
    }

    @Override
    public ServiceRegistryClient getServiceRegistryClient() {
        return this.srClient;
    }

    public void setServiceRegistryClient(ServiceRegistryClient serviceRegistryClient) {
        this.srClient = serviceRegistryClient;
    }

    public IpPortManager getIpPortManager() {
        return this.ipPortManager;
    }

    @Override
    public InstanceCacheManager getInstanceCacheManager() {
        return this.instanceCacheManager;
    }

    @Override
    public String getAppId() {
        return this.microservice.getAppId();
    }

    protected abstract ServiceRegistryClient createServiceRegistryClient();

    @Override
    public void run() {
        this.loadStaticConfiguration();
        this.loadFrameworkVersions();
        this.serviceCenterTask.init();
    }

    private void loadFrameworkVersions() {
        Framework framework = new Framework();
        framework.setName("servicecomb-java-chassis");
        framework.setVersion(FrameworkVersions.allVersions());
        this.microservice.setFramework(framework);
        this.microservice.setRegisterBy("SDK");
    }

    private void loadStaticConfiguration() {
        List<BasePath> paths = this.microservice.getPaths();
        for (BasePath path : paths) {
            if (path.getProperty() == null) {
                path.setProperty(new HashMap<String, String>());
            }
            path.getProperty().put("checksession", "false");
        }
    }

    private void createServiceCenterTask() {
        MicroserviceServiceCenterTask task = new MicroserviceServiceCenterTask(this.eventBus, this.serviceRegistryConfig, this.srClient, this.microservice);
        this.serviceCenterTask = new ServiceCenterTask(this.eventBus, this.serviceRegistryConfig.getHeartbeatInterval(), this.serviceRegistryConfig.getResendHeartBeatTimes(), task);
    }

    public boolean unregisterInstance() {
        MicroserviceInstance microserviceInstance = this.microservice.getInstance();
        if (microserviceInstance.getInstanceId() == null || microserviceInstance.getServiceId() == null) {
            return true;
        }
        boolean result = this.srClient.unregisterMicroserviceInstance(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId());
        if (!result) {
            LOGGER.error("Unregister microservice instance failed. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
            return false;
        }
        LOGGER.info("Unregister microservice instance success. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
        return true;
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        MicroserviceInstances instances = this.findServiceInstances(appId, serviceName, versionRule, null);
        if (instances == null || instances.isMicroserviceNotExist()) {
            return null;
        }
        return instances.getInstancesResponse().getInstances();
    }

    @Override
    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule, String revision) {
        MicroserviceInstances microserviceInstances = this.srClient.findServiceInstances(this.microservice.getServiceId(), appId, serviceName, versionRule, revision);
        if (microserviceInstances == null) {
            LOGGER.error("Can not find any instances from service center due to previous errors. service={}/{}/{}", new Object[]{appId, serviceName, versionRule});
            return null;
        }
        if (microserviceInstances.isMicroserviceNotExist()) {
            return microserviceInstances;
        }
        if (!microserviceInstances.isNeedRefresh()) {
            LOGGER.debug("instances revision is not changed, service={}/{}/{}", new Object[]{appId, serviceName, versionRule});
            return microserviceInstances;
        }
        List<MicroserviceInstance> instances = microserviceInstances.getInstancesResponse().getInstances();
        LOGGER.info("find instances[{}] from service center success. service={}/{}/{}, old revision={}, new revision={}", new Object[]{instances.size(), appId, serviceName, versionRule, revision, microserviceInstances.getRevision()});
        for (MicroserviceInstance instance : instances) {
            LOGGER.info("service id={}, instance id={}, endpoints={}", new Object[]{instance.getServiceId(), instance.getInstanceId(), instance.getEndpoints()});
        }
        return microserviceInstances;
    }

    @Override
    public boolean updateMicroserviceProperties(Map<String, String> properties) {
        boolean success = this.srClient.updateMicroserviceProperties(this.microservice.getServiceId(), properties);
        if (success) {
            this.microservice.setProperties(properties);
        }
        return success;
    }

    @Override
    public boolean updateInstanceProperties(Map<String, String> instanceProperties) {
        MicroserviceInstance microserviceInstance = this.microservice.getInstance();
        boolean success = this.srClient.updateInstanceProperties(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId(), instanceProperties);
        if (success) {
            microserviceInstance.setProperties(instanceProperties);
        }
        return success;
    }

    @Override
    public Microservice getRemoteMicroservice(String microserviceId) {
        return this.srClient.getMicroservice(microserviceId);
    }

    @Override
    public Microservice getAggregatedRemoteMicroservice(String microserviceId) {
        return this.srClient.getAggregatedMicroservice(microserviceId);
    }

    @Override
    public Microservice getMicroservice() {
        return this.microservice;
    }

    @Override
    public MicroserviceInstance getMicroserviceInstance() {
        return this.microservice.getInstance();
    }

    @Override
    public void destroy() {
        this.eventBus.post((Object)new ShutdownEvent());
        this.unregisterInstance();
    }

    @Override
    public void registerMicroserviceMapping(String microserviceName, String version, List<MicroserviceInstance> instances, Class<?> schemaIntfCls) {
        MicroserviceNameParser parser = new MicroserviceNameParser(this.microservice.getAppId(), microserviceName);
        MicroserviceManager microserviceManager = this.appManager.getOrCreateMicroserviceManager(parser.getAppId());
        microserviceManager.getVersionsByName().computeIfAbsent(microserviceName, svcName -> new StaticMicroserviceVersions(this.appManager, parser.getAppId(), microserviceName).init(schemaIntfCls, version, instances));
    }

    @Override
    public void registerMicroserviceMappingByEndpoints(String microserviceName, String version, List<String> endpoints, Class<?> schemaIntfCls) {
        ArrayList<MicroserviceInstance> microserviceInstances = new ArrayList<MicroserviceInstance>();
        for (String endpoint : endpoints) {
            MicroserviceInstance instance = new MicroserviceInstance();
            instance.setEndpoints(Collections.singletonList(endpoint));
            microserviceInstances.add(instance);
        }
        this.registerMicroserviceMapping(microserviceName, version, microserviceInstances, schemaIntfCls);
    }

    @Subscribe
    public void onShutdown(ShutdownEvent event) {
        LOGGER.info("service center task is shutdown.");
        this.executorService.shutdownNow();
    }

    @Subscribe
    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        this.executorService.execute(() -> this.appManager.onMicroserviceInstanceChanged(changedEvent));
    }

    @Subscribe
    public void serviceRegistryRecovery(RecoveryEvent event) {
        this.executorService.execute(this.appManager::pullInstances);
    }

    @Subscribe
    public void onSafeModeChanged(SafeModeChangeEvent modeChangeEvent) {
        this.executorService.execute(() -> this.appManager.onSafeModeChanged(modeChangeEvent));
    }
}

