/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.provider.springmvc.reference.CommonToHttpServletRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import org.apache.servicecomb.provider.springmvc.reference.RequestMeta;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.response.ResponsesMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class CseClientHttpRequest
implements ClientHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseClientHttpRequest.class);
    private URI uri;
    private String path;
    private HttpMethod method;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private InvocationContext context;
    private Object requestBody;
    private Map<String, List<String>> queryParams;
    private RequestMeta requestMeta;
    private Type responseType;

    public CseClientHttpRequest() {
    }

    public CseClientHttpRequest(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected RequestMeta getRequestMeta() {
        return this.requestMeta;
    }

    protected void setRequestMeta(RequestMeta requestMeta) {
        this.requestMeta = requestMeta;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    protected void setQueryParams(Map<String, List<String>> queryParams) {
        this.queryParams = queryParams;
    }

    public InvocationContext getContext() {
        return this.context;
    }

    public void setContext(InvocationContext context) {
        this.context = context;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Type responseType) {
        this.responseType = responseType;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public void setHttpHeaders(HttpHeaders headers) {
        if (headers != null) {
            this.httpHeaders = headers;
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getMethodValue() {
        return this.method.name();
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() {
        return null;
    }

    public ClientHttpResponse execute() {
        this.path = this.findUriPath(this.uri);
        this.requestMeta = this.createRequestMeta(this.method.name(), this.uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri.getRawSchemeSpecificPart());
        this.queryParams = queryStringDecoder.parameters();
        Map<String, Object> swaggerArguments = this.collectArguments();
        return this.invoke(swaggerArguments);
    }

    protected RequestMeta createRequestMeta(String httpMethod, URI uri) {
        String microserviceName = uri.getAuthority();
        MicroserviceReferenceConfig microserviceReferenceConfig = SCBEngine.getInstance().createMicroserviceReferenceConfig(microserviceName);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager((MicroserviceMeta)microserviceMeta);
        if (servicePathManager == null) {
            throw new Error(String.format("no schema defined for %s:%s", microserviceMeta.getAppId(), microserviceMeta.getMicroserviceName()));
        }
        OperationLocator locator = servicePathManager.consumerLocateOperation(this.path, httpMethod);
        RestOperationMeta swaggerRestOperation = locator.getOperation();
        OperationMeta operationMeta = locator.getOperation().getOperationMeta();
        ReferenceConfig referenceConfig = microserviceReferenceConfig.createReferenceConfig(operationMeta);
        Map pathParams = locator.getPathVarMap();
        return new RequestMeta(referenceConfig, swaggerRestOperation, pathParams);
    }

    protected String findUriPath(URI uri) {
        return uri.getRawPath();
    }

    protected Invocation prepareInvocation(Map<String, Object> swaggerArguments) {
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.requestMeta.getReferenceConfig(), (OperationMeta)this.requestMeta.getOperationMeta(), swaggerArguments);
        invocation.setWeakInvoke(true);
        invocation.getHandlerContext().put("rest-client-request-path", this.path + (this.uri.getRawQuery() == null ? "" : "?" + this.uri.getRawQuery()));
        if (this.context != null) {
            invocation.addContext(this.context);
        }
        if (!(this.responseType == null || this.responseType instanceof Class && Part.class.isAssignableFrom((Class)this.responseType))) {
            ResponsesMeta responsesMeta = new ResponsesMeta();
            invocation.getOperationMeta().getResponsesMeta().cloneTo(responsesMeta);
            responsesMeta.getResponseMap().put(Response.Status.OK.getStatusCode(), TypeFactory.defaultInstance().constructType(this.responseType));
            invocation.setResponsesMeta(responsesMeta);
        }
        invocation.getHandlerContext().put("servicecomb-rest-consumer-header", this.httpHeaders);
        return invocation;
    }

    private CseClientHttpResponse invoke(Map<String, Object> swaggerArguments) {
        Invocation invocation = this.prepareInvocation(swaggerArguments);
        Response response = this.doInvoke(invocation);
        if (response.isSuccessed()) {
            return new CseClientHttpResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected Response doInvoke(Invocation invocation) {
        return InvokerUtils.innerSyncInvoke((Invocation)invocation);
    }

    protected Map<String, Object> collectArguments() {
        CommonToHttpServletRequest mockRequest = new CommonToHttpServletRequest(this.requestMeta.getPathParams(), this.queryParams, (Map<String, List<String>>)this.httpHeaders, this.requestBody, this.requestMeta.getSwaggerRestOperation().isFormData(), this.requestMeta.getSwaggerRestOperation().getFileKeys());
        return RestCodec.restToArgs((HttpServletRequest)mockRequest, (RestOperationMeta)this.requestMeta.getSwaggerRestOperation());
    }
}

