/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTree;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;

public abstract class AbstractDiscoveryClient {
    private Map<String, DiscoveryTree> discoveryTrees = new ConcurrentHashMapEx();
    private DiscoveryFilter filter = null;

    public AbstractDiscoveryClient(DiscoveryFilter filter) {
        this.filter = filter;
    }

    public <T> List<T> doGetInstances(String serviceId) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)serviceId);
        DiscoveryTree discoveryTree = this.discoveryTrees.computeIfAbsent(serviceId, key -> {
            DiscoveryTree tree = new DiscoveryTree();
            tree.addFilter(this.filter);
            return tree;
        });
        DiscoveryTreeNode serversVersionedCache = discoveryTree.discovery(context, RegistryUtils.getAppId(), serviceId, "0.0.0.0+");
        return (List)serversVersionedCache.data();
    }

    public List<String> getServices() {
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        List services = client.getAllMicroservices();
        ArrayList<String> serviceIDList = new ArrayList<String>();
        if (null != services && !services.isEmpty()) {
            for (Microservice service : services) {
                serviceIDList.add(service.getServiceName());
            }
        }
        return serviceIDList;
    }
}

