/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

final class WebsocketServerOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketServerHandshaker handshaker;
    final ChannelPromise handshakerResult;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<WebsocketServerOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketServerOperations.class, "closeSent");

    WebsocketServerOperations(String wsUrl, @Nullable String protocols, int maxFramePayloadLength, HttpServerOperations replaced) {
        super(replaced);
        Channel channel = replaced.channel();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, protocols, true, maxFramePayloadLength);
        this.handshaker = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("reactor.left.httpTrafficHandler");
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (this.channel().pipeline().get("reactor.left.compressionHandler") != null) {
                this.removeHandler("reactor.left.compressionHandler");
                WebSocketServerCompressionHandler wsServerCompressionHandler = new WebSocketServerCompressionHandler();
                try {
                    wsServerCompressionHandler.channelRead(channel.pipeline().context("reactor.right.reactiveBridge"), (Object)request);
                    this.addHandlerFirst("reactor.left.wsCompressionHandler", (ChannelHandler)wsServerCompressionHandler);
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format(this.channel(), ""), e);
                }
            }
            this.handshaker.handshake(channel, (HttpRequest)request, replaced.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener(f -> this.markPersistent(false));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject((Publisher<?>)Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public HttpHeaders headers() {
        return this.requestHeaders();
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            this.onInboundComplete();
            CloseWebSocketFrame close = (CloseWebSocketFrame)frame;
            this.sendCloseNow(new CloseWebSocketFrame(true, close.rsv(), close.content()), f -> this.terminate());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        if (frame != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, frame);
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendCloseNow(new CloseWebSocketFrame(1002, "Server internal error"), f -> this.terminate());
        }
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.channel().pipeline().remove("reactor.right.reactiveBridge");
                    return this.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(@Nullable CloseWebSocketFrame frame, ChannelFutureListener listener) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            ChannelFuture f = this.channel().writeAndFlush((Object)(frame == null ? new CloseWebSocketFrame() : frame));
            f.addListener((GenericFutureListener)listener);
        } else if (frame != null) {
            frame.release();
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.selectedSubprotocol();
    }
}

