/*
 * Decompiled with CFR 0.152.
 */
package nl.jworks.markdown_to_asciidoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import nl.jworks.markdown_to_asciidoc.ToAsciiDocSerializer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;

public class Converter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("markdown_to_asciidoc: Please specify a file to convert");
            return;
        }
        File input = new File(args[0]);
        if (!input.exists()) {
            System.err.println("markdown_to_asciidoc: Cannot find the specified file to convert");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            try {
                String line;
                StringBuilder buffer = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
                reader.close();
                System.out.println(Converter.convertMarkdownToAsciiDoc(buffer.toString().trim()));
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            System.err.println("markdown_to_asciidoc: An error occurred while reading the input file");
        }
    }

    public static String convertMarkdownToAsciiDoc(String markdown) {
        PegDownProcessor processor = new PegDownProcessor(65535);
        if (markdown.contains("```")) {
            markdown = markdown.replaceAll("(?m)(?<!\n\n)(\\s*)```(\\w*\n)((?:\\1[^\n]*\n)+)\\1```", "\n$1```$2$3$1```");
        }
        char[] markDown = markdown.toCharArray();
        RootNode rootNode = processor.parseMarkdown(markDown);
        return new ToAsciiDocSerializer(rootNode, markdown).toAsciiDoc();
    }
}

