/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.definition;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Message;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.codec.protobuf.definition.RequestRootDeserializer;
import org.apache.servicecomb.codec.protobuf.definition.RequestRootSerializer;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootDeserializer;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;

public class OperationProtobuf {
    private OperationMeta operationMeta;
    private RequestRootSerializer requestRootSerializer;
    private RequestRootDeserializer<Object> requestRootDeserializer;
    private ResponseRootSerializer responseRootSerializer;
    private ResponseRootDeserializer<Object> responseRootDeserializer;
    private ResponseRootSerializer anyResponseRootSerializer;
    private ResponseRootDeserializer<Object> anyResponseRootDeserializer;

    public OperationProtobuf(ScopedProtobufSchemaManager scopedProtobufSchemaManager, OperationMeta operationMeta) {
        this.operationMeta = operationMeta;
        this.initRequestCodec(scopedProtobufSchemaManager, operationMeta);
        this.initResponseCodec(scopedProtobufSchemaManager, operationMeta);
    }

    public RequestRootSerializer getRequestRootSerializer() {
        return this.requestRootSerializer;
    }

    public RequestRootDeserializer<Object> getRequestRootDeserializer() {
        return this.requestRootDeserializer;
    }

    public ResponseRootSerializer findResponseRootSerializer(int statusCode) {
        if (Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode))) {
            return this.responseRootSerializer;
        }
        return this.anyResponseRootSerializer;
    }

    public ResponseRootDeserializer<Object> findResponseRootDeserializer(int statusCode) {
        if (Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)statusCode))) {
            return this.responseRootDeserializer;
        }
        return this.anyResponseRootDeserializer;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initRequestCodec(ScopedProtobufSchemaManager scopedProtobufSchemaManager, OperationMeta operationMeta) {
        ProtoMapper mapper = scopedProtobufSchemaManager.getOrCreateProtoMapper(operationMeta.getSchemaMeta());
        Message requestMessage = mapper.getRequestMessage(operationMeta.getOperationId());
        if (operationMeta.getSwaggerProducerOperation() != null) {
            Map swaggerParameterTypes = operationMeta.getSwaggerProducerOperation().getSwaggerParameterTypes();
            if (ProtoUtils.isWrapArguments((FieldContainer)requestMessage)) {
                this.requestRootDeserializer = new RequestRootDeserializer(mapper.createRootDeserializer(requestMessage, swaggerParameterTypes), true, null);
                return;
            } else if (swaggerParameterTypes.isEmpty()) {
                this.requestRootDeserializer = new RequestRootDeserializer(mapper.createRootDeserializer(requestMessage, Object.class), false, null);
                return;
            } else {
                if (swaggerParameterTypes.size() != 1) throw new IllegalStateException("unexpected operation definition " + operationMeta.getMicroserviceQualifiedName());
                Map.Entry entry = swaggerParameterTypes.entrySet().iterator().next();
                this.requestRootDeserializer = new RequestRootDeserializer(mapper.createRootDeserializer(requestMessage, (Type)entry.getValue()), false, (String)entry.getKey());
            }
            return;
        } else if (ProtoUtils.isWrapArguments((FieldContainer)requestMessage)) {
            this.requestRootSerializer = new RequestRootSerializer(mapper.createRootSerializer(requestMessage, Object.class), true, false);
            return;
        } else if (operationMeta.getSwaggerOperation().getParameters().isEmpty()) {
            this.requestRootSerializer = new RequestRootSerializer(mapper.createRootSerializer(requestMessage, Object.class), false, false);
            return;
        } else {
            if (operationMeta.getSwaggerOperation().getParameters().size() != 1) throw new IllegalStateException("unexpected operation definition " + operationMeta.getMicroserviceQualifiedName());
            this.requestRootSerializer = new RequestRootSerializer(mapper.createRootSerializer(requestMessage, Object.class), false, true);
        }
    }

    private void initResponseCodec(ScopedProtobufSchemaManager scopedProtobufSchemaManager, OperationMeta operationMeta) {
        ProtoMapper mapper = scopedProtobufSchemaManager.getOrCreateProtoMapper(operationMeta.getSchemaMeta());
        Message responseMessage = mapper.getResponseMessage(operationMeta.getOperationId());
        JavaType responseType = operationMeta.getResponsesMeta().findResponseType(Response.Status.OK.getStatusCode());
        if (operationMeta.getSwaggerProducerOperation() != null) {
            this.responseRootSerializer = ProtoUtils.isWrapProperty((FieldContainer)responseMessage) ? new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, (Type)responseType), true, false) : (ProtoUtils.isEmptyMessage((Message)responseMessage) ? new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, Object.class), false, false) : new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, (Type)responseType), false, true));
        } else if (ProtoUtils.isWrapProperty((FieldContainer)responseMessage)) {
            this.responseRootSerializer = new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, (Type)responseType), true, false);
            this.responseRootDeserializer = new ResponseRootDeserializer(mapper.createRootDeserializer(responseMessage, (Type)responseType), false);
        } else if (ProtoUtils.isEmptyMessage((Message)responseMessage)) {
            this.responseRootSerializer = new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, Object.class), false, false);
            this.responseRootDeserializer = new ResponseRootDeserializer(mapper.createRootDeserializer(responseMessage, Object.class), true);
        } else {
            this.responseRootSerializer = new ResponseRootSerializer(mapper.createRootSerializer(responseMessage, (Type)responseType), false, false);
            this.responseRootDeserializer = new ResponseRootDeserializer(mapper.createRootDeserializer(responseMessage, (Type)responseType), false);
        }
        this.anyResponseRootSerializer = new ResponseRootSerializer(mapper.createRootSerializer(ProtoConst.ANY, Object.class), false, true);
        this.anyResponseRootDeserializer = new ResponseRootDeserializer(mapper.createRootDeserializer(ProtoConst.ANY, Object.class), false);
    }
}

